/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.pushdowns;

import com.google.cloud.bigquery.connector.common.BigQueryPushdownException;
import com.google.cloud.bigquery.connector.common.BigQueryPushdownUnsupportedException;
import com.google.cloud.spark.bigquery.SparkBigQueryUtil;
import com.google.cloud.spark.bigquery.direct.BigQueryRDDFactory;
import com.google.cloud.spark.bigquery.direct.DirectBigQueryRelation;
import com.google.cloud.spark.bigquery.pushdowns.AggregateQuery;
import com.google.cloud.spark.bigquery.pushdowns.BigQuerySQLQuery;
import com.google.cloud.spark.bigquery.pushdowns.BinaryOperationExtractor$;
import com.google.cloud.spark.bigquery.pushdowns.CastExpressionExtractor$;
import com.google.cloud.spark.bigquery.pushdowns.FilterQuery;
import com.google.cloud.spark.bigquery.pushdowns.FilterQuery$;
import com.google.cloud.spark.bigquery.pushdowns.JoinExtractor$;
import com.google.cloud.spark.bigquery.pushdowns.JoinQuery;
import com.google.cloud.spark.bigquery.pushdowns.LeftSemiJoinQuery;
import com.google.cloud.spark.bigquery.pushdowns.ProjectQuery;
import com.google.cloud.spark.bigquery.pushdowns.SortLimitQuery;
import com.google.cloud.spark.bigquery.pushdowns.SourceQuery;
import com.google.cloud.spark.bigquery.pushdowns.SourceQuery$;
import com.google.cloud.spark.bigquery.pushdowns.SparkBigQueryPushdownUtil$;
import com.google.cloud.spark.bigquery.pushdowns.SparkExpressionConverter;
import com.google.cloud.spark.bigquery.pushdowns.SparkExpressionFactory;
import com.google.cloud.spark.bigquery.pushdowns.SparkPlanFactory;
import com.google.cloud.spark.bigquery.pushdowns.UnaryOperationExtractor$;
import com.google.cloud.spark.bigquery.pushdowns.UnionOperationExtractor$;
import com.google.cloud.spark.bigquery.pushdowns.WindowQuery;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.Cross$;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Expand;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.GlobalLimit;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.Limit$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.plans.logical.Window;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SparkStrategy;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.BaseRelation;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud!B\u0001\u0003\u0003\u0003y!\u0001\u0005\"jOF+XM]=TiJ\fG/Z4z\u0015\t\u0019A!A\u0005qkNDGm\\<og*\u0011QAB\u0001\tE&<\u0017/^3ss*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\tQa\u00197pk\u0012T!a\u0003\u0007\u0002\r\u001d|wn\u001a7f\u0015\u0005i\u0011aA2p[\u000e\u00011c\u0001\u0001\u0011SA\u0011\u0011C\n\b\u0003%\rr!a\u0005\u0011\u000f\u0005QqbBA\u000b\u001c\u001d\t1\u0012$D\u0001\u0018\u0015\tAb\"\u0001\u0004=e>|GOP\u0005\u00025\u0005\u0019qN]4\n\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001b\u0013\t9qD\u0003\u0002\u001d;%\u0011\u0011EI\u0001\u0004gFd'BA\u0004 \u0013\t!S%A\u0004qC\u000e\\\u0017mZ3\u000b\u0005\u0005\u0012\u0013BA\u0014)\u0005!\u0019FO]1uK\u001eL(B\u0001\u0013&!\tQS&D\u0001,\u0015\ta#%\u0001\u0005j]R,'O\\1m\u0013\tq3FA\u0004M_\u001e<\u0017N\\4\t\u0011A\u0002!\u0011!Q\u0001\nE\n1#\u001a=qe\u0016\u001c8/[8o\u0007>tg/\u001a:uKJ\u0004\"AM\u001a\u000e\u0003\tI!\u0001\u000e\u0002\u00031M\u0003\u0018M]6FqB\u0014Xm]:j_:\u001cuN\u001c<feR,'\u000f\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0003E)\u0007\u0010\u001d:fgNLwN\u001c$bGR|'/\u001f\t\u0003eaJ!!\u000f\u0002\u0003-M\u0003\u0018M]6FqB\u0014Xm]:j_:4\u0015m\u0019;pefD\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001P\u0001\u0011gB\f'o\u001b)mC:4\u0015m\u0019;pef\u0004\"AM\u001f\n\u0005y\u0012!\u0001E*qCJ\\\u0007\u000b\\1o\r\u0006\u001cGo\u001c:z\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0003\u0019a\u0014N\\5u}Q!!i\u0011#F!\t\u0011\u0004\u0001C\u00031\u007f\u0001\u0007\u0011\u0007C\u00037\u007f\u0001\u0007q\u0007C\u0003<\u007f\u0001\u0007A\bC\u0004H\u0001\t\u0007IQ\u0001%\u0002\u000b\u0005d\u0017.Y:\u0016\u0003%\u00032AS(R\u001b\u0005Y%B\u0001'N\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002\u001d\u0006)1oY1mC&\u0011\u0001k\u0013\u0002\t\u0013R,'/\u0019;peB\u0011!K\u0016\b\u0003'R\u0003\"AF'\n\u0005Uk\u0015A\u0002)sK\u0012,g-\u0003\u0002X1\n11\u000b\u001e:j]\u001eT!!V'\t\ri\u0003\u0001\u0015!\u0004J\u0003\u0019\tG.[1tA!)A\f\u0001C!;\u0006)\u0011\r\u001d9msR\u0011a\f\u001c\t\u0004?\u000e4gB\u00011c\u001d\t1\u0012-C\u0001O\u0013\t!S*\u0003\u0002eK\n\u00191+Z9\u000b\u0005\u0011j\u0005CA4k\u001b\u0005A'BA5&\u0003%)\u00070Z2vi&|g.\u0003\u0002lQ\nI1\u000b]1sWBc\u0017M\u001c\u0005\u0006[n\u0003\rA\\\u0001\u0005a2\fg\u000e\u0005\u0002pm6\t\u0001O\u0003\u0002re\u00069An\\4jG\u0006d'BA:u\u0003\u0015\u0001H.\u00198t\u0015\t)X%\u0001\u0005dCR\fG._:u\u0013\t9\bOA\u0006M_\u001eL7-\u00197QY\u0006t\u0007\"B=\u0001\t\u0003Q\u0018a\u00055bgVs7/\u001e9q_J$X\r\u001a(pI\u0016\u001cHCA>\u0000!\taX0D\u0001N\u0013\tqXJA\u0004C_>dW-\u00198\t\u000b5D\b\u0019\u00018\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006\u0005\u0001s-\u001a8fe\u0006$Xm\u00159be.\u0004F.\u00198Ge>lGj\\4jG\u0006d\u0007\u000b\\1o)\rq\u0016q\u0001\u0005\u0007[\u0006\u0005\u0001\u0019\u00018\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e\u0005\u00112\r\\3b]V\u0003Hj\\4jG\u0006d\u0007\u000b\\1o)\rq\u0017q\u0002\u0005\u0007[\u0006%\u0001\u0019\u00018\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016\u0005)s-\u001a;U_Blun\u001d;Qe>TWm\u0019;O_\u0012,w+\u001b;i\u00032L\u0017m]3e\u0007\u0006\u001cHo\u001d\u000b\u0005\u0003/\t\u0019\u0003E\u0003}\u00033\ti\"C\u0002\u0002\u001c5\u0013aa\u00149uS>t\u0007cA8\u0002 %\u0019\u0011\u0011\u00059\u0003\u000fA\u0013xN[3di\"1Q.!\u0005A\u00029Dq!a\n\u0001\t\u0003\tI#A\u0012hK:,'/\u0019;f\u0005&<\u0017+^3ssBc\u0017M\u001c$s_6dunZ5dC2\u0004F.\u00198\u0015\u0007\u0019\fY\u0003\u0003\u0004n\u0003K\u0001\rA\u001c\u0005\b\u0003_\u0001A\u0011AA\u0019\u0003\t:WM\\3sCR,\u0007K]8kK\u000e$\b\u000b\\1o\rJ|W\u000eT8hS\u000e\fG\u000e\u00157b]R)a-a\r\u00026!1Q.!\fA\u00029D\u0001\"a\u000e\u0002.\u0001\u0007\u0011QD\u0001\faJ|'.Z2u\u001d>$W\rC\u0004\u0002<\u0001!\t!!\u0010\u0002\u001b\u001d,GO\u0015#E\r\u0006\u001cGo\u001c:z)\u0011\ty$!\u0014\u0011\u000bq\fI\"!\u0011\u0011\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bR1!a\u0012\u0005\u0003\u0019!\u0017N]3di&!\u00111JA#\u0005I\u0011\u0015nZ)vKJL(\u000b\u0012#GC\u000e$xN]=\t\u0011\u0005=\u0013\u0011\ba\u0001\u0003#\n\u0011\"];fef\u0014vn\u001c;\u0011\u0007I\n\u0019&C\u0002\u0002V\t\u0011\u0001CQ5h#V,'/_*R\u0019F+XM]=\t\u000f\u0005e\u0003A\"\u0001\u0002\\\u0005!s-\u001a8fe\u0006$X-U;fef4%o\\7QY\u0006tgi\u001c:ECR\f7k\\;sG\u00164&\u0007\u0006\u0003\u0002^\u0005}\u0003#\u0002?\u0002\u001a\u0005E\u0003BB7\u0002X\u0001\u0007a\u000eC\u0004\u0002d\u0001!\t!!\u001a\u0002+\u001d,g.\u001a:bi\u0016\fV/\u001a:z\rJ|W\u000e\u00157b]R!\u0011QLA4\u0011\u0019i\u0017\u0011\ra\u0001]\"9\u00111\u000e\u0001\u0007\u0002\u00055\u0014\u0001E2sK\u0006$X-\u00168j_:\fV/\u001a:z)\u0011\ti&a\u001c\t\u0011\u0005E\u0014\u0011\u000ea\u0001\u0003g\n\u0001b\u00195jY\u0012\u0014XM\u001c\t\u0004?\u000et\u0007")
public abstract class BigQueryStrategy
extends SparkStrategy {
    private final SparkExpressionConverter expressionConverter;
    private final SparkExpressionFactory expressionFactory;
    private final SparkPlanFactory sparkPlanFactory;
    private final Iterator<String> alias;

    public final Iterator<String> alias() {
        return this.alias;
    }

    public Seq<SparkPlan> apply(LogicalPlan plan) {
        Nil$ nil$;
        if (this.hasUnsupportedNodes(plan)) {
            return Nil$.MODULE$;
        }
        try {
            nil$ = this.generateSparkPlanFromLogicalPlan(plan);
        }
        catch (Exception e) {
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> "Query pushdown failed: ", e);
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public boolean hasUnsupportedNodes(LogicalPlan plan) {
        boolean bl;
        Object object = new Object();
        try {
            plan.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BigQueryStrategy.$anonfun$hasUnsupportedNodes$1(this, object, x0$1);
                return BoxedUnit.UNIT;
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public Seq<SparkPlan> generateSparkPlanFromLogicalPlan(LogicalPlan plan) {
        Option<Project> projectNodeAddedBySpark;
        LogicalPlan cleanedPlan = this.cleanUpLogicalPlan(plan);
        if (SparkBigQueryUtil.isDataFrameShowMethodInStackTrace() && (projectNodeAddedBySpark = this.getTopMostProjectNodeWithAliasedCasts(cleanedPlan)).isDefined()) {
            if (!SparkBigQueryPushdownUtil$.MODULE$.isLimitTheChildToProjectNode((Project)projectNodeAddedBySpark.get())) {
                cleanedPlan = SparkBigQueryPushdownUtil$.MODULE$.addProjectNodeToThePlan(cleanedPlan, (Project)projectNodeAddedBySpark.get(), this.expressionFactory);
                projectNodeAddedBySpark = this.getTopMostProjectNodeWithAliasedCasts(cleanedPlan);
            }
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SparkPlan[]{this.generateProjectPlanFromLogicalPlan(cleanedPlan, (Project)projectNodeAddedBySpark.get())}));
        }
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SparkPlan[]{this.generateBigQueryPlanFromLogicalPlan(cleanedPlan)}));
    }

    public LogicalPlan cleanUpLogicalPlan(LogicalPlan plan) {
        return (LogicalPlan)plan.transform((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Project) {
                    Project project = (Project)A1;
                    Seq seq = project.projectList();
                    LogicalPlan child = project.child();
                    if (Nil$.MODULE$.equals(seq)) {
                        object = child;
                        return (B1)object;
                    }
                }
                if (A1 instanceof SubqueryAlias) {
                    SubqueryAlias subqueryAlias = (SubqueryAlias)A1;
                    LogicalPlan child = subqueryAlias.child();
                    object = child;
                    return (B1)object;
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                Project project;
                Seq seq;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof Project && Nil$.MODULE$.equals(seq = (project = (Project)logicalPlan).projectList()) ? true : logicalPlan instanceof SubqueryAlias;
                return bl;
            }
        });
    }

    public Option<Project> getTopMostProjectNodeWithAliasedCasts(LogicalPlan plan) {
        None$ none$;
        Object object = new Object();
        try {
            plan.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                BigQueryStrategy.$anonfun$getTopMostProjectNodeWithAliasedCasts$1(object, x0$2);
                return BoxedUnit.UNIT;
            });
            none$ = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                none$ = (Option)ex.value();
            }
            throw ex;
        }
        return none$;
    }

    public SparkPlan generateBigQueryPlanFromLogicalPlan(LogicalPlan plan) {
        Option<BigQuerySQLQuery> queryRoot = this.generateQueryFromPlan(plan);
        Option<BigQueryRDDFactory> bigQueryRDDFactory = this.getRDDFactory((BigQuerySQLQuery)queryRoot.get());
        return (SparkPlan)this.sparkPlanFactory.createBigQueryPlan((BigQuerySQLQuery)queryRoot.get(), (BigQueryRDDFactory)bigQueryRDDFactory.get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new BigQueryPushdownException("Could not generate BigQuery physical plan from query");
        });
    }

    public SparkPlan generateProjectPlanFromLogicalPlan(LogicalPlan plan, Project projectNode) {
        LogicalPlan planWithoutProjectNode = SparkBigQueryPushdownUtil$.MODULE$.removeProjectNodeFromPlan(plan, projectNode);
        SparkPlan bigQueryPlan = this.generateBigQueryPlanFromLogicalPlan(planWithoutProjectNode);
        return (SparkPlan)this.sparkPlanFactory.createProjectPlan(projectNode, bigQueryPlan).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new BigQueryPushdownException("Could not generate BigQuery physical plan from query");
        });
    }

    public Option<BigQueryRDDFactory> getRDDFactory(BigQuerySQLQuery queryRoot) {
        SourceQuery sourceQuery = (SourceQuery)queryRoot.find(new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends BigQuerySQLQuery, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof SourceQuery) {
                    SourceQuery sourceQuery = (SourceQuery)A1;
                    object = sourceQuery;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(BigQuerySQLQuery x2) {
                BigQuerySQLQuery bigQuerySQLQuery = x2;
                boolean bl = bigQuerySQLQuery instanceof SourceQuery;
                return bl;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new BigQueryPushdownException("Something went wrong: a query tree was generated with no SourceQuery.");
        });
        return new Some((Object)sourceQuery.bigQueryRDDFactory());
    }

    public abstract Option<BigQuerySQLQuery> generateQueryFromPlanForDataSourceV2(LogicalPlan var1);

    public Option<BigQuerySQLQuery> generateQueryFromPlan(LogicalPlan plan) {
        LogicalRelation logicalRelation;
        BaseRelation bqRelation;
        Option<BigQuerySQLQuery> option;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof NamedRelation) {
            option = this.generateQueryFromPlanForDataSourceV2(plan);
        } else if (logicalPlan instanceof LogicalRelation && (bqRelation = (logicalRelation = (LogicalRelation)logicalPlan).relation()) instanceof DirectBigQueryRelation) {
            DirectBigQueryRelation directBigQueryRelation = (DirectBigQueryRelation)bqRelation;
            option = new Some((Object)new SourceQuery(this.expressionConverter, this.expressionFactory, directBigQueryRelation.getBigQueryRDDFactory(), directBigQueryRelation.getTableName(), (Seq<Attribute>)logicalRelation.output(), (String)this.alias().next(), SourceQuery$.MODULE$.apply$default$7()));
        } else {
            Option<LogicalPlan> option2 = UnaryOperationExtractor$.MODULE$.unapply(logicalPlan);
            if (!option2.isEmpty()) {
                LogicalPlan node = (LogicalPlan)option2.get();
                option = this.generateQueryFromPlan((LogicalPlan)node.children().head()).map((Function1 & Serializable & scala.Serializable)subQuery -> {
                    Option option;
                    Option option2;
                    void var3_20;
                    boolean bl = false;
                    GlobalLimit globalLimit = null;
                    boolean bl2 = false;
                    Sort sort = null;
                    LogicalPlan logicalPlan = plan;
                    if (logicalPlan instanceof Filter) {
                        Filter filter = (Filter)logicalPlan;
                        Expression condition = filter.condition();
                        FilterQuery filterQuery = new FilterQuery($this.expressionConverter, $this.expressionFactory, (Seq<Expression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{condition}))), (BigQuerySQLQuery)subQuery, (String)this.alias().next(), FilterQuery$.MODULE$.apply$default$6());
                        return var3_20;
                    }
                    if (logicalPlan instanceof Project) {
                        Project project = (Project)logicalPlan;
                        Seq fields = project.projectList();
                        ProjectQuery projectQuery = new ProjectQuery($this.expressionConverter, $this.expressionFactory, (Seq<NamedExpression>)fields, (BigQuerySQLQuery)subQuery, (String)this.alias().next());
                        return var3_20;
                    }
                    if (logicalPlan instanceof Aggregate) {
                        Aggregate aggregate = (Aggregate)logicalPlan;
                        Seq groups = aggregate.groupingExpressions();
                        Seq fields = aggregate.aggregateExpressions();
                        AggregateQuery aggregateQuery = new AggregateQuery($this.expressionConverter, $this.expressionFactory, (Seq<NamedExpression>)fields, (Seq<Expression>)groups, (BigQuerySQLQuery)subQuery, (String)this.alias().next());
                        return var3_20;
                    }
                    if (logicalPlan instanceof GlobalLimit) {
                        bl = true;
                        globalLimit = (GlobalLimit)logicalPlan;
                        Option option3 = Limit$.MODULE$.unapply(globalLimit);
                        if (!option3.isEmpty()) {
                            LogicalPlan logicalPlan2;
                            GlobalLimit globalLimit2;
                            Option option4;
                            Expression limitExpr = (Expression)((Tuple2)option3.get())._1();
                            LogicalPlan logicalPlan3 = (LogicalPlan)((Tuple2)option3.get())._2();
                            if (logicalPlan3 instanceof GlobalLimit && !(option4 = Limit$.MODULE$.unapply(globalLimit2 = (GlobalLimit)logicalPlan3)).isEmpty() && (logicalPlan2 = (LogicalPlan)((Tuple2)option4.get())._2()) instanceof Sort) {
                                Sort sort2 = (Sort)logicalPlan2;
                                Seq orderExpr = sort2.order();
                                boolean bl3 = sort2.global();
                                if (bl3) {
                                    SortLimitQuery sortLimitQuery = new SortLimitQuery($this.expressionConverter, $this.expressionFactory, (Option<Expression>)new Some((Object)limitExpr), (Seq<Expression>)orderExpr, (BigQuerySQLQuery)subQuery, (String)this.alias().next());
                                    return var3_20;
                                }
                            }
                        }
                    }
                    if (bl && !(option2 = Limit$.MODULE$.unapply(globalLimit)).isEmpty()) {
                        Expression limitExpr = (Expression)((Tuple2)option2.get())._1();
                        LogicalPlan logicalPlan4 = (LogicalPlan)((Tuple2)option2.get())._2();
                        if (logicalPlan4 instanceof Sort) {
                            Sort sort3 = (Sort)logicalPlan4;
                            Seq orderExpr = sort3.order();
                            boolean bl4 = sort3.global();
                            if (bl4) {
                                SortLimitQuery sortLimitQuery = new SortLimitQuery($this.expressionConverter, $this.expressionFactory, (Option<Expression>)new Some((Object)limitExpr), (Seq<Expression>)orderExpr, (BigQuerySQLQuery)subQuery, (String)this.alias().next());
                                return var3_20;
                            }
                        }
                    }
                    if (bl && !(option = Limit$.MODULE$.unapply(globalLimit)).isEmpty()) {
                        Expression limitExpr = (Expression)((Tuple2)option.get())._1();
                        SortLimitQuery sortLimitQuery = new SortLimitQuery($this.expressionConverter, $this.expressionFactory, (Option<Expression>)new Some((Object)limitExpr), (Seq<Expression>)((Seq)Seq$.MODULE$.empty()), (BigQuerySQLQuery)subQuery, (String)this.alias().next());
                        return var3_20;
                    }
                    if (logicalPlan instanceof Sort) {
                        GlobalLimit globalLimit3;
                        Option option5;
                        bl2 = true;
                        sort = (Sort)logicalPlan;
                        Seq orderExpr = sort.order();
                        boolean bl5 = sort.global();
                        LogicalPlan logicalPlan5 = sort.child();
                        if (bl5 && logicalPlan5 instanceof GlobalLimit && !(option5 = Limit$.MODULE$.unapply(globalLimit3 = (GlobalLimit)logicalPlan5)).isEmpty()) {
                            Expression limitExpr = (Expression)((Tuple2)option5.get())._1();
                            SortLimitQuery sortLimitQuery = new SortLimitQuery($this.expressionConverter, $this.expressionFactory, (Option<Expression>)new Some((Object)limitExpr), (Seq<Expression>)orderExpr, (BigQuerySQLQuery)subQuery, (String)this.alias().next());
                            return var3_20;
                        }
                    }
                    if (bl2) {
                        Seq orderExpr = sort.order();
                        boolean bl6 = sort.global();
                        if (bl6) {
                            SortLimitQuery sortLimitQuery = new SortLimitQuery($this.expressionConverter, $this.expressionFactory, (Option<Expression>)None$.MODULE$, (Seq<Expression>)orderExpr, (BigQuerySQLQuery)subQuery, (String)this.alias().next());
                            return var3_20;
                        }
                    }
                    if (!(logicalPlan instanceof Window)) {
                        BigQuerySQLQuery bigQuerySQLQuery = subQuery;
                        return var3_20;
                    }
                    Window window = (Window)logicalPlan;
                    Seq windowExpressions = window.windowExpressions();
                    WindowQuery windowQuery = new WindowQuery($this.expressionConverter, $this.expressionFactory, (Seq<NamedExpression>)windowExpressions, (BigQuerySQLQuery)subQuery, (Option<Seq<Attribute>>)(plan.output().isEmpty() ? None$.MODULE$ : new Some((Object)plan.output())), (String)this.alias().next());
                    return var3_20;
                });
            } else {
                Union union;
                Option<Seq<LogicalPlan>> option3;
                Option<LogicalPlan> option4 = BinaryOperationExtractor$.MODULE$.unapply(logicalPlan);
                if (!option4.isEmpty()) {
                    LogicalPlan node = (LogicalPlan)option4.get();
                    option = this.generateQueryFromPlan((LogicalPlan)node.children().head()).flatMap((Function1 & Serializable & scala.Serializable)l -> this.generateQueryFromPlan((LogicalPlan)node.children().apply(1)).map((Function1 & Serializable & scala.Serializable)r -> {
                        void var5_14;
                        LogicalPlan logicalPlan = plan;
                        if (!(logicalPlan instanceof Join)) throw new MatchError((Object)logicalPlan);
                        Join join = (Join)logicalPlan;
                        Option<Tuple2<JoinType, Option<Expression>>> option = JoinExtractor$.MODULE$.unapply(join);
                        if (option.isEmpty()) throw new MatchError((Object)logicalPlan);
                        JoinType joinType = (JoinType)((Tuple2)option.get())._1();
                        Option condition = (Option)((Tuple2)option.get())._2();
                        JoinType joinType2 = joinType;
                        boolean bl = Inner$.MODULE$.equals(joinType2) ? true : (LeftOuter$.MODULE$.equals(joinType2) ? true : (RightOuter$.MODULE$.equals(joinType2) ? true : (FullOuter$.MODULE$.equals(joinType2) ? true : Cross$.MODULE$.equals(joinType2))));
                        if (bl) {
                            JoinQuery joinQuery = new JoinQuery($this.expressionConverter, $this.expressionFactory, (BigQuerySQLQuery)l, (BigQuerySQLQuery)r, (Option<Expression>)condition, joinType, (String)this.alias().next());
                            return var5_14;
                        } else if (LeftSemi$.MODULE$.equals(joinType2)) {
                            LeftSemiJoinQuery leftSemiJoinQuery = new LeftSemiJoinQuery($this.expressionConverter, $this.expressionFactory, (BigQuerySQLQuery)l, (BigQuerySQLQuery)r, (Option<Expression>)condition, false, this.alias());
                            return var5_14;
                        } else {
                            if (!LeftAnti$.MODULE$.equals(joinType2)) throw new MatchError((Object)BoxedUnit.UNIT);
                            LeftSemiJoinQuery leftSemiJoinQuery = new LeftSemiJoinQuery($this.expressionConverter, $this.expressionFactory, (BigQuerySQLQuery)l, (BigQuerySQLQuery)r, (Option<Expression>)condition, true, this.alias());
                        }
                        return var5_14;
                    }));
                } else if (logicalPlan instanceof Union && !(option3 = UnionOperationExtractor$.MODULE$.unapply(union = (Union)logicalPlan)).isEmpty()) {
                    Seq children = (Seq)option3.get();
                    option = this.createUnionQuery((Seq<LogicalPlan>)children);
                } else if (logicalPlan instanceof Expand) {
                    Expand expand = (Expand)logicalPlan;
                    Seq projections = expand.projections();
                    Seq output = expand.output();
                    LogicalPlan child = expand.child();
                    Seq projectPlan = (Seq)projections.map((Function1 & Serializable & scala.Serializable)p -> {
                        Seq<NamedExpression> namedExpressions = SparkBigQueryPushdownUtil$.MODULE$.convertExpressionToNamedExpression((Seq<Expression>)p, (Seq<Attribute>)output, $this.expressionFactory);
                        return new Project(namedExpressions, child);
                    }, Seq$.MODULE$.canBuildFrom());
                    option = this.createUnionQuery((Seq<LogicalPlan>)projectPlan);
                } else {
                    throw new BigQueryPushdownUnsupportedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Query pushdown failed in generateQueries for node ", " in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{plan.nodeName(), plan.getClass().getName()})));
                }
            }
        }
        return option;
    }

    public abstract Option<BigQuerySQLQuery> createUnionQuery(Seq<LogicalPlan> var1);

    public static final /* synthetic */ String $anonfun$alias$1(int n) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SUBQUERY_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)}));
    }

    public static final /* synthetic */ void $anonfun$hasUnsupportedNodes$1(BigQueryStrategy $this, Object nonLocalReturnKey1$1, LogicalPlan x0$1) {
        Union union;
        Option<Seq<LogicalPlan>> option;
        Option<LogicalPlan> option2;
        LogicalPlan logicalPlan = x0$1;
        Option<LogicalPlan> option3 = UnaryOperationExtractor$.MODULE$.unapply(logicalPlan);
        boolean bl = !option3.isEmpty() ? true : (!(option2 = BinaryOperationExtractor$.MODULE$.unapply(logicalPlan)).isEmpty() ? true : logicalPlan instanceof Union && !(option = UnionOperationExtractor$.MODULE$.unapply(union = (Union)logicalPlan)).isEmpty());
        if (bl) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl2 = logicalPlan instanceof LogicalRelation ? true : (logicalPlan instanceof NamedRelation ? true : logicalPlan instanceof Expand);
            if (bl2) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LogicalPlan has unsupported node for query pushdown : ", " in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logicalPlan.nodeName(), logicalPlan.getClass().getName()})));
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$getTopMostProjectNodeWithAliasedCasts$2(Project x2$1, Object nonLocalReturnKey2$1, NamedExpression x0$3) {
        NamedExpression namedExpression = x0$3;
        if (namedExpression instanceof Alias) {
            Alias alias = (Alias)namedExpression;
            Expression child = alias.child();
            Expression expression = child;
            Option<Expression> option = CastExpressionExtractor$.MODULE$.unapply(expression);
            if (!option.isEmpty()) {
                throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)new Some((Object)x2$1));
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$getTopMostProjectNodeWithAliasedCasts$1(Object nonLocalReturnKey2$1, LogicalPlan x0$2) {
        LogicalPlan logicalPlan = x0$2;
        boolean bl = logicalPlan instanceof Aggregate ? true : (logicalPlan instanceof Join ? true : (logicalPlan instanceof LogicalRelation ? true : logicalPlan instanceof NamedRelation));
        if (bl) {
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)None$.MODULE$);
        }
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            Seq projectList = project.projectList();
            projectList.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                BigQueryStrategy.$anonfun$getTopMostProjectNodeWithAliasedCasts$2(project, nonLocalReturnKey2$1, x0$3);
                return BoxedUnit.UNIT;
            });
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)None$.MODULE$);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public BigQueryStrategy(SparkExpressionConverter expressionConverter, SparkExpressionFactory expressionFactory, SparkPlanFactory sparkPlanFactory) {
        this.expressionConverter = expressionConverter;
        this.expressionFactory = expressionFactory;
        this.sparkPlanFactory = sparkPlanFactory;
        this.alias = package$.MODULE$.Iterator().from(0).map((Function1 & Serializable & scala.Serializable)n -> BigQueryStrategy.$anonfun$alias$1(BoxesRunTime.unboxToInt((Object)n)));
    }
}

