/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.longrunning;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.ApiClock;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.InternalApi;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.NanoClock;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OperationTimedPollAlgorithm
extends ExponentialRetryAlgorithm {
    @VisibleForTesting
    static final Logger LOGGER = Logger.getLogger(OperationTimedPollAlgorithm.class.getName());
    @VisibleForTesting
    static final String LRO_TROUBLESHOOTING_LINK = "https://github.com/googleapis/google-cloud-java#lro-timeouts";

    public static OperationTimedPollAlgorithm create(RetrySettings globalSettings) {
        return new OperationTimedPollAlgorithm(globalSettings, NanoClock.getDefaultClock());
    }

    public static OperationTimedPollAlgorithm create(RetrySettings globalSettings, ApiClock clock) {
        return new OperationTimedPollAlgorithm(globalSettings, clock);
    }

    private OperationTimedPollAlgorithm(RetrySettings globalSettings, ApiClock clock) {
        super(globalSettings, clock);
    }

    @Override
    public boolean shouldRetry(TimedAttemptSettings nextAttemptSettings) throws CancellationException {
        if (super.shouldRetry(nextAttemptSettings)) {
            return true;
        }
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "The task has been cancelled. Please refer to https://github.com/googleapis/google-cloud-java#lro-timeouts for more information");
        }
        throw new CancellationException();
    }

    @Override
    @InternalApi
    protected boolean shouldRPCTerminate(long timeLeftMs) {
        return timeLeftMs < 0L;
    }
}

