/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.processor;

import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.auto.common.MoreElements;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.auto.common.MoreTypes;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.common.collect.ImmutableList;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.org.objectweb.asm.ClassWriter;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.org.objectweb.asm.MethodVisitor;
import java.util.stream.Collectors;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class ForwardingClassGenerator {
    static byte[] makeConstructorForwarder(String forwardingClassName, TypeMirror classToConstruct, ImmutableList<TypeMirror> constructorParameters) {
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(52, 48, ForwardingClassGenerator.internalName(forwardingClassName), null, "java/lang/Object", null);
        classWriter.visitSource(forwardingClassName, null);
        String parameterSignature = constructorParameters.stream().map(ForwardingClassGenerator::signatureEncoding).collect(Collectors.joining(""));
        String internalClassToConstruct = ForwardingClassGenerator.internalName(MoreTypes.asTypeElement(classToConstruct));
        String ofMethodSignature = "(" + parameterSignature + ")L" + internalClassToConstruct + ";";
        MethodVisitor ofMethodVisitor = classWriter.visitMethod(8, "of", ofMethodSignature, null, null);
        ofMethodVisitor.visitCode();
        ofMethodVisitor.visitTypeInsn(187, internalClassToConstruct);
        ofMethodVisitor.visitInsn(89);
        int local = 0;
        for (TypeMirror type : constructorParameters) {
            ofMethodVisitor.visitVarInsn(ForwardingClassGenerator.loadInstruction(type), local);
            local += ForwardingClassGenerator.localSize(type);
        }
        String constructorToCallSignature = "(" + parameterSignature + ")V";
        ofMethodVisitor.visitMethodInsn(183, internalClassToConstruct, "<init>", constructorToCallSignature, false);
        ofMethodVisitor.visitInsn(176);
        ofMethodVisitor.visitMaxs(0, 0);
        ofMethodVisitor.visitEnd();
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static int loadInstruction(TypeMirror type) {
        switch (type.getKind()) {
            case DECLARED: 
            case ARRAY: {
                return 25;
            }
            case LONG: {
                return 22;
            }
            case FLOAT: {
                return 23;
            }
            case DOUBLE: {
                return 24;
            }
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case BOOLEAN: {
                return 21;
            }
        }
        throw new IllegalArgumentException("Unexpected type " + type);
    }

    private static int localSize(TypeMirror type) {
        switch (type.getKind()) {
            case LONG: 
            case DOUBLE: {
                return 2;
            }
        }
        return 1;
    }

    private static String internalName(String className) {
        return className.replace('.', '/');
    }

    private static String internalName(TypeElement typeElement) {
        if (typeElement.getNestingKind().equals((Object)NestingKind.MEMBER)) {
            TypeElement enclosing = MoreElements.asType(typeElement.getEnclosingElement());
            return ForwardingClassGenerator.internalName(enclosing) + "$" + typeElement.getSimpleName();
        }
        return ForwardingClassGenerator.internalName(typeElement.getQualifiedName().toString());
    }

    private static String signatureEncoding(TypeMirror type) {
        switch (type.getKind()) {
            case ARRAY: {
                return "[" + ForwardingClassGenerator.signatureEncoding(MoreTypes.asArray(type).getComponentType());
            }
            case BYTE: {
                return "B";
            }
            case SHORT: {
                return "S";
            }
            case INT: {
                return "I";
            }
            case LONG: {
                return "J";
            }
            case FLOAT: {
                return "F";
            }
            case DOUBLE: {
                return "D";
            }
            case CHAR: {
                return "C";
            }
            case BOOLEAN: {
                return "Z";
            }
            case DECLARED: {
                return "L" + ForwardingClassGenerator.internalName(MoreTypes.asTypeElement(type)) + ";";
            }
        }
        throw new AssertionError((Object)("Bad signature type " + type));
    }

    private ForwardingClassGenerator() {
    }
}

