/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.processor;

import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.auto.common.MoreElements;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.auto.common.MoreTypes;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.common.collect.ImmutableMap;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.common.collect.ImmutableSet;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.processor.AnnotatedTypeMirror;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.processor.BuilderMethodClassifier;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.processor.ErrorReporter;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.processor.MethodSignature;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.processor.Nullables;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.processor.SimpleMethod;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.processor.TypeEncoder;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class PropertyBuilderClassifier {
    private final ErrorReporter errorReporter;
    private final Types typeUtils;
    private final Elements elementUtils;
    private final BuilderMethodClassifier<?> builderMethodClassifier;
    private final Predicate<String> propertyIsNullable;
    private final ImmutableMap<String, AnnotatedTypeMirror> propertyTypes;
    private final Nullables nullables;
    private static final ImmutableSet<String> BUILDER_METHOD_NAMES = ImmutableSet.of("naturalOrder", "builder", "newBuilder");
    private static final ImmutableSet<String> ONE_ARGUMENT_BUILDER_METHOD_NAMES = ImmutableSet.of("builder");
    private static final ImmutableSet<String> ADD_ALL_PUT_ALL = ImmutableSet.of("addAll", "putAll");

    PropertyBuilderClassifier(ErrorReporter errorReporter, Types typeUtils, Elements elementUtils, BuilderMethodClassifier<?> builderMethodClassifier, Predicate<String> propertyIsNullable, ImmutableMap<String, AnnotatedTypeMirror> propertyTypes, Nullables nullables) {
        this.errorReporter = errorReporter;
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
        this.builderMethodClassifier = builderMethodClassifier;
        this.propertyIsNullable = propertyIsNullable;
        this.propertyTypes = propertyTypes;
        this.nullables = nullables;
    }

    Optional<PropertyBuilder> makePropertyBuilder(ExecutableElement method, String property) {
        String initDefault;
        String beforeInitDefault;
        boolean hasOf;
        Optional<ExecutableElement> maybeBuilderMaker;
        AnnotatedTypeMirror barBuilderAnnotatedType = this.builderMethodClassifier.builderMethodReturnType(method);
        if (barBuilderAnnotatedType.getKind() != TypeKind.DECLARED) {
            this.errorReporter.reportError(method, "[AutoValueOddBuilderMethod] Method looks like a property builder, but its return type is not a class or interface", new Object[0]);
            return Optional.empty();
        }
        DeclaredType barBuilderDeclaredType = MoreTypes.asDeclared(barBuilderAnnotatedType.getType());
        TypeElement barBuilderTypeElement = MoreTypes.asTypeElement(barBuilderDeclaredType);
        Map<String, ExecutableElement> barBuilderNoArgMethods = this.noArgMethodsOf(barBuilderTypeElement);
        TypeMirror barTypeMirror = this.propertyTypes.get(property).getType();
        if (barTypeMirror.getKind() != TypeKind.DECLARED) {
            this.errorReporter.reportError(method, "[AutoValueBadBuilderMethod] Method looks like a property builder, but the type of property %s is not a class or interface", property);
            return Optional.empty();
        }
        if (this.propertyIsNullable.test(property)) {
            this.errorReporter.reportError(method, "[AutoValueNullBuilder] Property %s is @Nullable so it cannot have a property builder", property);
        }
        TypeElement barTypeElement = MoreTypes.asTypeElement(barTypeMirror);
        Map<String, ExecutableElement> barNoArgMethods = this.noArgMethodsOf(barTypeElement);
        ExecutableElement build = barBuilderNoArgMethods.get("buildOrThrow");
        if (build == null) {
            build = barBuilderNoArgMethods.get("build");
        }
        if (build == null || build.getModifiers().contains((Object)Modifier.STATIC)) {
            this.errorReporter.reportError(method, "[AutoValueBuilderNotBuildable] Method looks like a property builder, but it returns %s which does not have a non-static build() or buildOrThrow() method", barBuilderTypeElement);
            return Optional.empty();
        }
        TypeMirror buildType = MethodSignature.asMemberOf(this.typeUtils, barBuilderDeclaredType, build).returnType().getType();
        if (!this.typeUtils.isAssignable(buildType, barTypeMirror)) {
            this.errorReporter.reportError(method, "[AutoValueBuilderWrongType] Property builder for %s has type %s whose %s() method returns %s instead of %s", property, barBuilderTypeElement, build.getSimpleName(), buildType, barTypeMirror);
            return Optional.empty();
        }
        if (method.getParameters().isEmpty()) {
            maybeBuilderMaker = this.noArgBuilderMaker(barNoArgMethods, barBuilderTypeElement);
        } else {
            ImmutableMap<String, ExecutableElement> barOneArgMethods = this.oneArgumentMethodsOf(barTypeElement);
            maybeBuilderMaker = this.oneArgBuilderMaker(barOneArgMethods, barBuilderTypeElement);
        }
        if (!maybeBuilderMaker.isPresent()) {
            this.errorReporter.reportError(method, "[AutoValueCantMakePropertyBuilder] Method looks like a property builder, but its type %s does not have a public constructor and %s does not have a static builder() or newBuilder() method that returns %s", barBuilderTypeElement, barTypeElement, barBuilderTypeElement);
            return Optional.empty();
        }
        ExecutableElement builderMaker = maybeBuilderMaker.get();
        String barBuilderType = TypeEncoder.encodeWithAnnotations(barBuilderAnnotatedType);
        String nullableBarBuilderType = TypeEncoder.encodeWithAnnotations(barBuilderAnnotatedType, this.nullables.nullableTypeAnnotations());
        String rawBarType = TypeEncoder.encodeRaw(barTypeMirror);
        String arguments = method.getParameters().isEmpty() ? "()" : "(" + method.getParameters().get(0).getSimpleName() + ")";
        String initializer = builderMaker.getKind() == ElementKind.CONSTRUCTOR ? "new " + barBuilderType + arguments : rawBarType + "." + builderMaker.getSimpleName() + arguments;
        String builtToBuilder = null;
        String copyAll = null;
        ExecutableElement toBuilder = barNoArgMethods.get("toBuilder");
        if (toBuilder != null && !toBuilder.getModifiers().contains((Object)Modifier.STATIC) && this.typeUtils.isAssignable(this.typeUtils.erasure(toBuilder.getReturnType()), this.typeUtils.erasure(barBuilderDeclaredType))) {
            builtToBuilder = toBuilder.getSimpleName().toString();
        } else {
            Optional<ExecutableElement> maybeCopyAll = this.addAllPutAll(barBuilderTypeElement, barBuilderDeclaredType, barTypeMirror);
            if (maybeCopyAll.isPresent()) {
                copyAll = maybeCopyAll.get().getSimpleName().toString();
            }
        }
        ExecutableElement barOf = barNoArgMethods.get("of");
        boolean bl = hasOf = barOf != null && barOf.getModifiers().contains((Object)Modifier.STATIC);
        if (hasOf) {
            beforeInitDefault = "";
            initDefault = rawBarType + ".of()";
        } else {
            String localBuilder = property + "$builder";
            beforeInitDefault = nullableBarBuilderType + " " + localBuilder + " = " + initializer + ";";
            initDefault = localBuilder + "." + build.getSimpleName() + "()";
        }
        PropertyBuilder propertyBuilder = new PropertyBuilder(method, barBuilderType, nullableBarBuilderType, barBuilderAnnotatedType, build.getSimpleName().toString(), initializer, beforeInitDefault, initDefault, builtToBuilder, copyAll);
        return Optional.of(propertyBuilder);
    }

    private Optional<ExecutableElement> noArgBuilderMaker(Map<String, ExecutableElement> barNoArgMethods, TypeElement barBuilderTypeElement) {
        return this.builderMaker(BUILDER_METHOD_NAMES, barNoArgMethods, barBuilderTypeElement, 0);
    }

    private Optional<ExecutableElement> oneArgBuilderMaker(Map<String, ExecutableElement> barOneArgMethods, TypeElement barBuilderTypeElement) {
        return this.builderMaker(ONE_ARGUMENT_BUILDER_METHOD_NAMES, barOneArgMethods, barBuilderTypeElement, 1);
    }

    private Optional<ExecutableElement> builderMaker(ImmutableSet<String> methodNamesToCheck, Map<String, ExecutableElement> methods, TypeElement barBuilderTypeElement, int argumentCount) {
        Optional<ExecutableElement> maybeMethod = methodNamesToCheck.stream().map(methods::get).filter(Objects::nonNull).filter(method -> method.getModifiers().contains((Object)Modifier.STATIC)).filter(method -> this.typeUtils.isSameType(this.typeUtils.erasure(method.getReturnType()), this.typeUtils.erasure(barBuilderTypeElement.asType()))).findFirst();
        if (maybeMethod.isPresent()) {
            return maybeMethod;
        }
        return ElementFilter.constructorsIn(barBuilderTypeElement.getEnclosedElements()).stream().filter(c -> c.getParameters().size() == argumentCount).filter(c -> c.getModifiers().contains((Object)Modifier.PUBLIC)).findFirst();
    }

    private Map<String, ExecutableElement> noArgMethodsOf(TypeElement type) {
        return this.methodsOf(type, 0);
    }

    private ImmutableMap<String, ExecutableElement> oneArgumentMethodsOf(TypeElement type) {
        return this.methodsOf(type, 1);
    }

    private ImmutableMap<String, ExecutableElement> methodsOf(TypeElement type, int argumentCount) {
        return ElementFilter.methodsIn(this.elementUtils.getAllMembers(type)).stream().filter(method -> method.getParameters().size() == argumentCount).filter(method -> !PropertyBuilderClassifier.isStaticInterfaceMethodNotIn(method, type)).collect(Collectors.collectingAndThen(Collectors.toMap(method -> method.getSimpleName().toString(), Function.identity(), (method1, method2) -> method1), ImmutableMap::copyOf));
    }

    private static boolean isStaticInterfaceMethodNotIn(ExecutableElement method, TypeElement type) {
        return method.getModifiers().contains((Object)Modifier.STATIC) && !method.getEnclosingElement().equals(type) && method.getEnclosingElement().getKind().equals((Object)ElementKind.INTERFACE);
    }

    private Optional<ExecutableElement> addAllPutAll(TypeElement barBuilderTypeElement, DeclaredType barBuilderDeclaredType, TypeMirror barTypeMirror) {
        return MoreElements.getLocalAndInheritedMethods(barBuilderTypeElement, this.typeUtils, this.elementUtils).stream().filter(method -> ADD_ALL_PUT_ALL.contains(method.getSimpleName().toString()) && method.getParameters().size() == 1).filter(method -> {
            TypeMirror parameterType = ((AnnotatedTypeMirror)MethodSignature.asMemberOf(this.typeUtils, barBuilderDeclaredType, method).parameterTypes().get(0)).getType();
            return this.typeUtils.isAssignable(barTypeMirror, parameterType);
        }).findFirst();
    }

    public static class PropertyBuilder {
        private final ExecutableElement propertyBuilderMethod;
        private final String name;
        private final String builderType;
        private final String nullableBuilderType;
        private final AnnotatedTypeMirror builderAnnotatedType;
        private final String build;
        private final String initializer;
        private final String beforeInitDefault;
        private final String initDefault;
        private final String builtToBuilder;
        private final String copyAll;

        PropertyBuilder(ExecutableElement propertyBuilderMethod, String builderType, String nullableBuilderType, AnnotatedTypeMirror builderAnnotatedType, String build, String initializer, String beforeInitDefault, String initDefault, String builtToBuilder, String copyAll) {
            this.propertyBuilderMethod = propertyBuilderMethod;
            this.name = propertyBuilderMethod.getSimpleName() + "$";
            this.builderType = builderType;
            this.nullableBuilderType = nullableBuilderType;
            this.builderAnnotatedType = builderAnnotatedType;
            this.build = build;
            this.initializer = initializer;
            this.beforeInitDefault = beforeInitDefault;
            this.initDefault = initDefault;
            this.builtToBuilder = builtToBuilder;
            this.copyAll = copyAll;
        }

        public ExecutableElement getPropertyBuilderMethod() {
            return this.propertyBuilderMethod;
        }

        public String getMethodName() {
            return this.propertyBuilderMethod.getSimpleName().toString();
        }

        public String getPropertyBuilderMethodParameters() {
            return this.propertyBuilderMethod.getParameters().stream().map(parameter -> TypeEncoder.encode(parameter.asType()) + " " + parameter.getSimpleName()).collect(Collectors.joining(", "));
        }

        public String getAccess() {
            return SimpleMethod.access(this.propertyBuilderMethod);
        }

        public String getName() {
            return this.name;
        }

        public String getBuilderType() {
            return this.builderType;
        }

        public String getNullableBuilderType() {
            return this.nullableBuilderType;
        }

        TypeMirror getBuilderTypeMirror() {
            return this.builderAnnotatedType.getType();
        }

        public String getBuild() {
            return this.build;
        }

        public String getInitializer() {
            return this.initializer;
        }

        public String getBeforeInitDefault() {
            return this.beforeInitDefault;
        }

        public String getInitDefault() {
            return this.initDefault;
        }

        public String getBuiltToBuilder() {
            return this.builtToBuilder;
        }

        public String getCopyAll() {
            return this.copyAll;
        }
    }
}

