/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.JobInfo;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableId;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Function;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Strings;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class CopyJobConfiguration
extends JobConfiguration {
    private static final long serialVersionUID = 1140509641399762967L;
    private final List<TableId> sourceTables;
    private final TableId destinationTable;
    private final String operationType;
    private final String destinationExpirationTime;
    private final JobInfo.CreateDisposition createDisposition;
    private final JobInfo.WriteDisposition writeDisposition;
    private final EncryptionConfiguration destinationEncryptionConfiguration;
    private final Map<String, String> labels;
    private final Long jobTimeoutMs;

    private CopyJobConfiguration(Builder builder) {
        super(builder);
        this.sourceTables = Preconditions.checkNotNull(builder.sourceTables);
        this.destinationTable = Preconditions.checkNotNull(builder.destinationTable);
        this.operationType = builder.operationType;
        this.destinationExpirationTime = builder.destinationExpirationTime;
        this.createDisposition = builder.createDisposition;
        this.writeDisposition = builder.writeDisposition;
        this.destinationEncryptionConfiguration = builder.destinationEncryptionConfiguration;
        this.labels = builder.labels;
        this.jobTimeoutMs = builder.jobTimeoutMs;
    }

    public List<TableId> getSourceTables() {
        return this.sourceTables;
    }

    public TableId getDestinationTable() {
        return this.destinationTable;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public String getDestinationExpirationTime() {
        return this.destinationExpirationTime;
    }

    public EncryptionConfiguration getDestinationEncryptionConfiguration() {
        return this.destinationEncryptionConfiguration;
    }

    public JobInfo.CreateDisposition getCreateDisposition() {
        return this.createDisposition;
    }

    public JobInfo.WriteDisposition getWriteDisposition() {
        return this.writeDisposition;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Long getJobTimeoutMs() {
        return this.jobTimeoutMs;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("sourceTables", this.sourceTables).add("destinationTable", this.destinationTable).add("operationType", this.operationType).add("destinationExpirationTime", this.destinationExpirationTime).add("destinationEncryptionConfiguration", this.destinationEncryptionConfiguration).add("createDisposition", (Object)this.createDisposition).add("writeDisposition", (Object)this.writeDisposition).add("labels", this.labels).add("jobTimeoutMs", this.jobTimeoutMs);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof CopyJobConfiguration && this.baseEquals((CopyJobConfiguration)obj);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseHashCode(), this.sourceTables, this.destinationTable, this.operationType, this.destinationExpirationTime, this.createDisposition, this.writeDisposition, this.labels, this.jobTimeoutMs});
    }

    @Override
    CopyJobConfiguration setProjectId(final String projectId) {
        Builder builder = this.toBuilder();
        builder.setSourceTables(Lists.transform(this.getSourceTables(), new Function<TableId, TableId>(){

            @Override
            public TableId apply(TableId tableId) {
                if (Strings.isNullOrEmpty(tableId.getProject())) {
                    return tableId.setProjectId(projectId);
                }
                return tableId;
            }
        }));
        if (Strings.isNullOrEmpty(this.getDestinationTable().getProject())) {
            builder.setDestinationTable(this.getDestinationTable().setProjectId(projectId));
        }
        return builder.build();
    }

    @Override
    com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.JobConfiguration toPb() {
        JobConfigurationTableCopy configurationPb = new JobConfigurationTableCopy();
        com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.JobConfiguration jobConfiguration = new com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.JobConfiguration();
        configurationPb.setDestinationTable(this.destinationTable.toPb());
        if (this.sourceTables != null) {
            configurationPb.setSourceTables(Lists.transform(this.sourceTables, TableId.TO_PB_FUNCTION));
        }
        if (this.operationType != null) {
            configurationPb.setOperationType(this.operationType);
        }
        if (this.destinationExpirationTime != null) {
            configurationPb.setDestinationExpirationTime(this.destinationExpirationTime);
        }
        if (this.createDisposition != null) {
            configurationPb.setCreateDisposition(this.createDisposition.toString());
        }
        if (this.writeDisposition != null) {
            configurationPb.setWriteDisposition(this.writeDisposition.toString());
        }
        if (this.destinationEncryptionConfiguration != null) {
            configurationPb.setDestinationEncryptionConfiguration(this.destinationEncryptionConfiguration.toPb());
        }
        if (this.labels != null) {
            jobConfiguration.setLabels(this.labels);
        }
        if (this.jobTimeoutMs != null) {
            jobConfiguration.setJobTimeoutMs(this.jobTimeoutMs);
        }
        jobConfiguration.setCopy(configurationPb);
        return jobConfiguration;
    }

    public static Builder newBuilder(TableId destinationTable, TableId sourceTable) {
        return CopyJobConfiguration.newBuilder(destinationTable, ImmutableList.of(Preconditions.checkNotNull(sourceTable)));
    }

    public static Builder newBuilder(TableId destinationTable, List<TableId> sourceTables) {
        return new Builder().setDestinationTable(destinationTable).setSourceTables(sourceTables);
    }

    public static CopyJobConfiguration of(TableId destinationTable, TableId sourceTable) {
        return CopyJobConfiguration.newBuilder(destinationTable, sourceTable).build();
    }

    public static CopyJobConfiguration of(TableId destinationTable, List<TableId> sourceTables) {
        return CopyJobConfiguration.newBuilder(destinationTable, sourceTables).build();
    }

    static CopyJobConfiguration fromPb(com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.JobConfiguration jobPb) {
        return new Builder(jobPb).build();
    }

    public static final class Builder
    extends JobConfiguration.Builder<CopyJobConfiguration, Builder> {
        private List<TableId> sourceTables;
        private TableId destinationTable;
        private String operationType;
        private String destinationExpirationTime;
        private JobInfo.CreateDisposition createDisposition;
        private JobInfo.WriteDisposition writeDisposition;
        private EncryptionConfiguration destinationEncryptionConfiguration;
        private Map<String, String> labels;
        private Long jobTimeoutMs;

        private Builder() {
            super(JobConfiguration.Type.COPY);
        }

        private Builder(CopyJobConfiguration jobConfiguration) {
            this();
            this.sourceTables = jobConfiguration.sourceTables;
            this.destinationTable = jobConfiguration.destinationTable;
            this.operationType = jobConfiguration.operationType;
            this.destinationExpirationTime = jobConfiguration.destinationExpirationTime;
            this.createDisposition = jobConfiguration.createDisposition;
            this.writeDisposition = jobConfiguration.writeDisposition;
            this.destinationEncryptionConfiguration = jobConfiguration.destinationEncryptionConfiguration;
            this.labels = jobConfiguration.labels;
            this.jobTimeoutMs = jobConfiguration.jobTimeoutMs;
        }

        private Builder(com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.JobConfiguration configurationPb) {
            this();
            JobConfigurationTableCopy copyConfigurationPb = configurationPb.getCopy();
            this.destinationTable = TableId.fromPb(copyConfigurationPb.getDestinationTable());
            if (copyConfigurationPb.getOperationType() != null) {
                this.operationType = copyConfigurationPb.getOperationType();
            }
            if (copyConfigurationPb.getDestinationExpirationTime() != null) {
                this.destinationExpirationTime = copyConfigurationPb.getDestinationExpirationTime().toString();
            }
            this.sourceTables = copyConfigurationPb.getSourceTables() != null ? Lists.transform(copyConfigurationPb.getSourceTables(), TableId.FROM_PB_FUNCTION) : ImmutableList.of(TableId.fromPb(copyConfigurationPb.getSourceTable()));
            if (copyConfigurationPb.getCreateDisposition() != null) {
                this.createDisposition = JobInfo.CreateDisposition.valueOf(copyConfigurationPb.getCreateDisposition());
            }
            if (copyConfigurationPb.getWriteDisposition() != null) {
                this.writeDisposition = JobInfo.WriteDisposition.valueOf(copyConfigurationPb.getWriteDisposition());
            }
            if (copyConfigurationPb.getDestinationEncryptionConfiguration() != null) {
                this.destinationEncryptionConfiguration = new EncryptionConfiguration.Builder(copyConfigurationPb.getDestinationEncryptionConfiguration()).build();
            }
            if (configurationPb.getLabels() != null) {
                this.labels = configurationPb.getLabels();
            }
            if (configurationPb.getJobTimeoutMs() != null) {
                this.jobTimeoutMs = configurationPb.getJobTimeoutMs();
            }
        }

        public Builder setSourceTables(List<TableId> sourceTables) {
            this.sourceTables = sourceTables != null ? ImmutableList.copyOf(sourceTables) : null;
            return this;
        }

        public Builder setDestinationTable(TableId destinationTable) {
            this.destinationTable = destinationTable;
            return this;
        }

        public Builder setOperationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        public Builder setDestinationExpirationTime(String destinationExpirationTime) {
            this.destinationExpirationTime = destinationExpirationTime;
            return this;
        }

        public Builder setDestinationEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.destinationEncryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public Builder setCreateDisposition(JobInfo.CreateDisposition createDisposition) {
            this.createDisposition = createDisposition;
            return this;
        }

        public Builder setWriteDisposition(JobInfo.WriteDisposition writeDisposition) {
            this.writeDisposition = writeDisposition;
            return this;
        }

        public Builder setLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder setJobTimeoutMs(Long jobTimeoutMs) {
            this.jobTimeoutMs = jobTimeoutMs;
            return this;
        }

        @Override
        public CopyJobConfiguration build() {
            return new CopyJobConfiguration(this);
        }
    }
}

