/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery;

import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.CopyJobConfiguration;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.ExtractJobConfiguration;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public abstract class JobConfiguration
implements Serializable {
    private static final long serialVersionUID = -548132177415406526L;
    private final Type type;

    JobConfiguration(Builder builder) {
        this.type = builder.type;
    }

    public Type getType() {
        return this.type;
    }

    public abstract Builder toBuilder();

    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper(this).add("type", (Object)this.type);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    final int baseHashCode() {
        return Objects.hash(new Object[]{this.type});
    }

    final boolean baseEquals(JobConfiguration jobConfiguration) {
        return Objects.equals(this.toPb(), jobConfiguration.toPb());
    }

    abstract JobConfiguration setProjectId(String var1);

    abstract com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.JobConfiguration toPb();

    static <T extends JobConfiguration> T fromPb(com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.JobConfiguration configurationPb) {
        if (configurationPb.getCopy() != null) {
            return (T)CopyJobConfiguration.fromPb(configurationPb);
        }
        if (configurationPb.getExtract() != null) {
            return (T)ExtractJobConfiguration.fromPb(configurationPb);
        }
        if (configurationPb.getLoad() != null) {
            return (T)LoadJobConfiguration.fromPb(configurationPb);
        }
        if (configurationPb.getQuery() != null) {
            return (T)QueryJobConfiguration.fromPb(configurationPb);
        }
        throw new IllegalArgumentException("Job configuration is not supported");
    }

    public static abstract class Builder<T extends JobConfiguration, B extends Builder<T, B>> {
        private Type type;

        Builder(Type type) {
            this.type = Preconditions.checkNotNull(type);
        }

        B self() {
            return (B)this;
        }

        B setType(Type type) {
            this.type = Preconditions.checkNotNull(type);
            return this.self();
        }

        public abstract T build();
    }

    public static enum Type {
        COPY,
        EXTRACT,
        LOAD,
        QUERY;

    }
}

