/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1beta1.stub.readrows;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.InternalApi;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1beta1.Storage;
import javax.annotation.Nonnull;

@InternalApi
public class ReadRowsResumptionStrategy
implements StreamResumptionStrategy<Storage.ReadRowsRequest, Storage.ReadRowsResponse> {
    private long rowsProcessed = 0L;

    @Override
    @Nonnull
    public StreamResumptionStrategy<Storage.ReadRowsRequest, Storage.ReadRowsResponse> createNew() {
        return new ReadRowsResumptionStrategy();
    }

    @Override
    @Nonnull
    public Storage.ReadRowsResponse processResponse(Storage.ReadRowsResponse response) {
        this.rowsProcessed += response.getRowCount();
        return response;
    }

    @Override
    public Storage.ReadRowsRequest getResumeRequest(Storage.ReadRowsRequest originalRequest) {
        Storage.ReadRowsRequest.Builder resumeRequestBuilder = originalRequest.toBuilder();
        resumeRequestBuilder.getReadPositionBuilder().setOffset(originalRequest.getReadPosition().getOffset() + this.rowsProcessed);
        return resumeRequestBuilder.build();
    }

    @Override
    public boolean canResume() {
        return true;
    }
}

