/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.grpc.alts;

import com.google.cloud.spark.bigquery.repackaged.io.grpc.CallOptions;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.Channel;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ClientCall;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ManagedChannel;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.MethodDescriptor;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.internal.SharedResourceHolder;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.netty.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.netty.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

final class HandshakerServiceChannel {
    static final SharedResourceHolder.Resource<Channel> SHARED_HANDSHAKER_CHANNEL = new ChannelResource("metadata.google.internal.:8080");

    HandshakerServiceChannel() {
    }

    static SharedResourceHolder.Resource<Channel> getHandshakerChannelForTesting(String handshakerAddress) {
        return new ChannelResource(handshakerAddress);
    }

    private static class EventLoopHoldingChannel
    extends ForwardingChannel {
        private final ManagedChannel delegate;
        private final EventLoopGroup eventLoopGroup;

        public EventLoopHoldingChannel(ManagedChannel delegate, EventLoopGroup eventLoopGroup) {
            this.delegate = delegate;
            this.eventLoopGroup = eventLoopGroup;
        }

        @Override
        protected Channel delegate() {
            return this.delegate;
        }

        public void close() {
            this.delegate.shutdownNow();
            boolean terminated = false;
            try {
                terminated = this.delegate.awaitTermination(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long quietPeriodSeconds = terminated ? 0L : 1L;
            this.eventLoopGroup.shutdownGracefully(quietPeriodSeconds, 10L, TimeUnit.SECONDS);
        }
    }

    private static abstract class ForwardingChannel
    extends Channel {
        private ForwardingChannel() {
        }

        protected abstract Channel delegate();

        @Override
        public String authority() {
            return this.delegate().authority();
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions options) {
            return this.delegate().newCall(methodDescriptor, options);
        }
    }

    private static class ChannelResource
    implements SharedResourceHolder.Resource<Channel> {
        private final String target;

        public ChannelResource(String target) {
            this.target = target;
        }

        @Override
        public Channel create() {
            NioEventLoopGroup eventGroup = new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory("handshaker pool", true));
            ManagedChannel channel = ((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)this.target).channelType(NioSocketChannel.class, InetSocketAddress.class).directExecutor()).eventLoopGroup((EventLoopGroup)eventGroup).usePlaintext().build();
            return new EventLoopHoldingChannel(channel, (EventLoopGroup)eventGroup);
        }

        @Override
        public void close(Channel instanceChannel) {
            ((EventLoopHoldingChannel)instanceChannel).close();
        }

        public String toString() {
            return "grpc-alts-handshaker-service-channel";
        }
    }
}

