/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LongIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.LongIntToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.LongIntPredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.LongLongProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.ListIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.ImmutableLongList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.ordered.primitive.ReversibleLongIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.primitive.LongLongPair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.primitive.LongObjectPair;
import java.util.Objects;
import java.util.Spliterator;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;

public interface LongList
extends ReversibleLongIterable {
    public long get(int var1);

    public long dotProduct(LongList var1);

    public int binarySearch(long var1);

    public int lastIndexOf(long var1);

    @Override
    public LongList select(LongPredicate var1);

    @Override
    public LongList reject(LongPredicate var1);

    @Override
    default public LongList tap(LongProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    default public void forEachInBoth(LongList other, LongLongProcedure procedure) {
        Objects.requireNonNull(other);
        if (this.size() != other.size()) {
            throw new IllegalArgumentException("Attempt to call forEachInBoth with two LongList instances of different sizes :" + this.size() + ':' + other.size());
        }
        this.forEachWithIndex((each, index) -> procedure.value(each, other.get(index)));
    }

    @Override
    default public LongList selectWithIndex(LongIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.select(each -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    @Override
    default public LongList rejectWithIndex(LongIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.reject(each -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    public <V> ListIterable<V> collect(LongToObjectFunction<? extends V> var1);

    default public <V> ListIterable<V> collectWithIndex(LongIntToObjectFunction<? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((long each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.value(each, n);
        });
    }

    public boolean equals(Object var1);

    public int hashCode();

    public ImmutableLongList toImmutable();

    @Override
    public LongList distinct();

    @Override
    public LongList toReversed();

    public LongList subList(int var1, int var2);

    default public ListIterable<LongLongPair> zipLong(LongIterable iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    default public <T> ListIterable<LongObjectPair<T>> zip(Iterable<T> iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    public Spliterator.OfLong spliterator();

    default public LongStream primitiveStream() {
        return StreamSupport.longStream(this.spliterator(), false);
    }

    default public LongStream primitiveParallelStream() {
        return StreamSupport.longStream(this.spliterator(), true);
    }
}

