/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.ByteIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.comparator.primitive.ByteComparator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ByteIntToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.ByteIntPredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.MutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.ByteList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.ImmutableByteList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.primitive.ByteBytePair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.primitive.ByteObjectPair;
import java.util.Comparator;
import java.util.Random;

public interface MutableByteList
extends MutableByteCollection,
ByteList {
    public void addAtIndex(int var1, byte var2);

    public boolean addAllAtIndex(int var1, byte ... var2);

    public boolean addAllAtIndex(int var1, ByteIterable var2);

    public byte removeAtIndex(int var1);

    public byte set(int var1, byte var2);

    default public void swap(int index1, int index2) {
        byte value = this.get(index1);
        this.set(index1, this.get(index2));
        this.set(index2, value);
    }

    @Override
    public MutableByteList select(BytePredicate var1);

    @Override
    public MutableByteList reject(BytePredicate var1);

    @Override
    public MutableByteList with(byte var1);

    @Override
    public MutableByteList without(byte var1);

    @Override
    public MutableByteList withAll(ByteIterable var1);

    @Override
    public MutableByteList withoutAll(ByteIterable var1);

    @Override
    default public MutableByteList tap(ByteProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    @Override
    default public MutableByteList selectWithIndex(ByteIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.select(each -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    @Override
    default public MutableByteList rejectWithIndex(ByteIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.reject(each -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    public <V> MutableList<V> collect(ByteToObjectFunction<? extends V> var1);

    default public <V> MutableList<V> collectWithIndex(ByteIntToObjectFunction<? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((byte each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.value(each, n);
        });
    }

    public MutableByteList reverseThis();

    @Override
    public MutableByteList toReversed();

    @Override
    public MutableByteList distinct();

    public MutableByteList sortThis();

    default public MutableByteList sortThis(ByteComparator comparator) {
        throw new UnsupportedOperationException("sortThis(ByteComparator comparator) is not supported on " + this.getClass());
    }

    default public <T> MutableByteList sortThisBy(ByteToObjectFunction<T> function) {
        return this.sortThisBy(function, Comparator.naturalOrder());
    }

    default public <T> MutableByteList sortThisBy(ByteToObjectFunction<T> function, Comparator<? super T> comparator) {
        return this.sortThis((i1, i2) -> comparator.compare((Object)function.valueOf(i1), (Object)function.valueOf(i2)));
    }

    default public MutableByteList shuffleThis() {
        return this.shuffleThis(new Random());
    }

    default public MutableByteList shuffleThis(Random rnd) {
        for (int j = this.size() - 1; j > 0; --j) {
            int k = rnd.nextInt(j + 1);
            byte selected = this.get(j);
            this.set(j, this.get(k));
            this.set(k, selected);
        }
        return this;
    }

    @Override
    public MutableByteList asUnmodifiable();

    @Override
    public MutableByteList asSynchronized();

    @Override
    public ImmutableByteList toImmutable();

    @Override
    public MutableByteList subList(int var1, int var2);

    default public MutableList<ByteBytePair> zipByte(ByteIterable iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    default public <T> MutableList<ByteObjectPair<T>> zip(Iterable<T> list) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    @Override
    default public MutableByteList newEmpty() {
        throw new UnsupportedOperationException("Implement in concrete classes.");
    }
}

