/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.MutableBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function0;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ByteFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.CharFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.FloatFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.IntFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.LongFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ShortFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Maps;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.ListIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.MutableMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.multimap.list.MutableListMultimap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.partition.stack.PartitionMutableStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.StackIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.MutableBooleanStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.MutableByteStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.MutableCharStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.MutableDoubleStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.MutableFloatStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.MutableIntStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.MutableLongStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.MutableShortStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.Pair;
import java.util.Collection;

public interface MutableStack<T>
extends StackIterable<T> {
    public void push(T var1);

    public T pop();

    public ListIterable<T> pop(int var1);

    public <R extends Collection<T>> R pop(int var1, R var2);

    public <R extends MutableStack<T>> R pop(int var1, R var2);

    public void clear();

    @Override
    public MutableStack<T> takeWhile(Predicate<? super T> var1);

    @Override
    public MutableStack<T> dropWhile(Predicate<? super T> var1);

    @Override
    public PartitionMutableStack<T> partitionWhile(Predicate<? super T> var1);

    @Override
    public MutableStack<T> distinct();

    public MutableStack<T> asUnmodifiable();

    public MutableStack<T> asSynchronized();

    @Override
    public MutableStack<T> tap(Procedure<? super T> var1);

    @Override
    public MutableStack<T> select(Predicate<? super T> var1);

    @Override
    public <P> MutableStack<T> selectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public MutableStack<T> reject(Predicate<? super T> var1);

    @Override
    public <P> MutableStack<T> rejectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <S> MutableStack<S> selectInstancesOf(Class<S> var1);

    @Override
    public PartitionMutableStack<T> partition(Predicate<? super T> var1);

    @Override
    public <P> PartitionMutableStack<T> partitionWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <V> MutableStack<V> collect(Function<? super T, ? extends V> var1);

    @Override
    public MutableBooleanStack collectBoolean(BooleanFunction<? super T> var1);

    @Override
    public MutableByteStack collectByte(ByteFunction<? super T> var1);

    @Override
    public MutableCharStack collectChar(CharFunction<? super T> var1);

    @Override
    public MutableDoubleStack collectDouble(DoubleFunction<? super T> var1);

    @Override
    public MutableFloatStack collectFloat(FloatFunction<? super T> var1);

    @Override
    public MutableIntStack collectInt(IntFunction<? super T> var1);

    @Override
    public MutableLongStack collectLong(LongFunction<? super T> var1);

    @Override
    public MutableShortStack collectShort(ShortFunction<? super T> var1);

    @Override
    public <P, V> MutableStack<V> collectWith(Function2<? super T, ? super P, ? extends V> var1, P var2);

    @Override
    public <V> MutableStack<V> collectIf(Predicate<? super T> var1, Function<? super T, ? extends V> var2);

    @Override
    default public <V> MutableStack<V> collectWithIndex(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((T each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.valueOf(each, n);
        });
    }

    @Override
    public <V> MutableStack<V> flatCollect(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    default public <P, V> MutableStack<V> flatCollectWith(Function2<? super T, ? super P, ? extends Iterable<V>> function, P parameter) {
        return this.flatCollect((T each) -> (Iterable)function.apply((Object)each, (Object)parameter));
    }

    @Override
    public <V> MutableObjectLongMap<V> sumByInt(Function<? super T, ? extends V> var1, IntFunction<? super T> var2);

    @Override
    public <V> MutableObjectDoubleMap<V> sumByFloat(Function<? super T, ? extends V> var1, FloatFunction<? super T> var2);

    @Override
    public <V> MutableObjectLongMap<V> sumByLong(Function<? super T, ? extends V> var1, LongFunction<? super T> var2);

    @Override
    public <V> MutableObjectDoubleMap<V> sumByDouble(Function<? super T, ? extends V> var1, DoubleFunction<? super T> var2);

    @Override
    public <V> MutableListMultimap<V, T> groupBy(Function<? super T, ? extends V> var1);

    @Override
    default public <V> MutableBag<V> countBy(Function<? super T, ? extends V> function) {
        return this.asLazy().collect((Function)function).toBag();
    }

    @Override
    default public <V, P> MutableBag<V> countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.asLazy().collectWith((Function2)function, (Object)parameter).toBag();
    }

    @Override
    default public <V> MutableBag<V> countByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.asLazy().flatCollect((Function)function).toBag();
    }

    @Override
    public <V> MutableListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    default public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.groupByUniqueKey(function, Maps.mutable.withInitialCapacity(this.size()));
    }

    @Override
    public <S> MutableStack<Pair<T, S>> zip(Iterable<S> var1);

    @Override
    public MutableStack<Pair<T, Integer>> zipWithIndex();

    @Override
    default public <K, V> MutableMap<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        MutableMap map = Maps.mutable.empty();
        this.forEach((? super T each) -> {
            Object key = groupBy.valueOf(each);
            Function0 value = map.getIfAbsentPut(key, zeroValueFactory);
            mutatingAggregator.value((Object)value, (Object)each);
        });
        return map;
    }

    @Override
    default public <K, V> MutableMap<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        MutableMap map = Maps.mutable.empty();
        this.forEach((? super T each) -> {
            Object key = groupBy.valueOf(each);
            map.updateValueWith(key, zeroValueFactory, nonMutatingAggregator, each);
        });
        return map;
    }
}

