/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.immutable;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.ImmutableBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.MutableBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.MutableBagIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.ImmutableBooleanBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.ImmutableCharBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.ImmutableShortBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ByteFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.CharFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.FloatFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.IntFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.LongFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ShortFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Bags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.BooleanBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.ByteBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.CharBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.DoubleBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.FloatBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.IntBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.LongBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.ShortBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.ImmutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.MutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.ImmutableMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.partition.bag.PartitionImmutableBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.primitive.ObjectIntPair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.immutable.AbstractImmutableBagIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.factory.Functions;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.factory.Predicates;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.UnifiedMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.partition.bag.PartitionHashBag;
import java.util.Iterator;

public abstract class AbstractImmutableBag<T>
extends AbstractImmutableBagIterable<T>
implements ImmutableBag<T> {
    @Override
    public ImmutableBag<T> newWithoutAll(Iterable<? extends T> elements) {
        return this.reject(Predicates.in(elements));
    }

    @Override
    public ImmutableBag<T> toImmutable() {
        return this;
    }

    @Override
    public ImmutableBag<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    @Override
    public <P> ImmutableBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.select((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public <P> ImmutableBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.reject((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public PartitionImmutableBag<T> partition(Predicate<? super T> predicate) {
        PartitionHashBag partitionMutableBag = new PartitionHashBag();
        this.forEachWithOccurrences((each, occurrences) -> {
            MutableBagIterable bucket = predicate.accept(each) ? partitionMutableBag.getSelected() : partitionMutableBag.getRejected();
            bucket.addOccurrences(each, occurrences);
        });
        return partitionMutableBag.toImmutable();
    }

    @Override
    public <P> PartitionImmutableBag<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        PartitionHashBag partitionMutableBag = new PartitionHashBag();
        this.forEachWithOccurrences((each, occurrences) -> {
            MutableBagIterable bucket = predicate.accept((Object)each, (Object)parameter) ? partitionMutableBag.getSelected() : partitionMutableBag.getRejected();
            bucket.addOccurrences(each, occurrences);
        });
        return partitionMutableBag.toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> countBy(Function<? super T, ? extends V> function) {
        return this.collect((Function)function);
    }

    @Override
    public <V, P> ImmutableBag<V> countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collectWith((Function2)function, (Object)parameter);
    }

    @Override
    public <V> ImmutableBag<V> countByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect((Function)function);
    }

    @Override
    public <V> ImmutableBag<V> collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        return this.collectWithOccurrences(function, Bags.mutable.empty()).toImmutable();
    }

    @Override
    public <P, V> ImmutableBag<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collect((Function)Functions.bind(function, parameter));
    }

    @Override
    public ImmutableBooleanBag collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return this.collectBoolean(booleanFunction, BooleanBags.mutable.empty()).toImmutable();
    }

    @Override
    public ImmutableByteBag collectByte(ByteFunction<? super T> byteFunction) {
        return this.collectByte(byteFunction, ByteBags.mutable.empty()).toImmutable();
    }

    @Override
    public ImmutableCharBag collectChar(CharFunction<? super T> charFunction) {
        return this.collectChar(charFunction, CharBags.mutable.empty()).toImmutable();
    }

    @Override
    public ImmutableDoubleBag collectDouble(DoubleFunction<? super T> doubleFunction) {
        return this.collectDouble(doubleFunction, DoubleBags.mutable.empty()).toImmutable();
    }

    @Override
    public ImmutableFloatBag collectFloat(FloatFunction<? super T> floatFunction) {
        return this.collectFloat(floatFunction, FloatBags.mutable.empty()).toImmutable();
    }

    @Override
    public ImmutableIntBag collectInt(IntFunction<? super T> intFunction) {
        return this.collectInt(intFunction, IntBags.mutable.empty()).toImmutable();
    }

    @Override
    public ImmutableLongBag collectLong(LongFunction<? super T> longFunction) {
        return this.collectLong(longFunction, LongBags.mutable.empty()).toImmutable();
    }

    @Override
    public ImmutableShortBag collectShort(ShortFunction<? super T> shortFunction) {
        return this.collectShort(shortFunction, ShortBags.mutable.empty()).toImmutable();
    }

    @Override
    public ImmutableList<ObjectIntPair<T>> topOccurrences(int n) {
        MutableList result = this.occurrencesSortingBy(n, item -> -item.getTwo(), Lists.fixedSize.empty());
        return result.toImmutable();
    }

    @Override
    public ImmutableList<ObjectIntPair<T>> bottomOccurrences(int n) {
        MutableList result = this.occurrencesSortingBy(n, ObjectIntPair::getTwo, Lists.fixedSize.empty());
        return result.toImmutable();
    }

    @Override
    public <V> ImmutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.groupByUniqueKey(function, UnifiedMap.newMap(this.size())).toImmutable();
    }

    @Override
    public RichIterable<RichIterable<T>> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        Iterator iterator = this.iterator();
        MutableList result = Lists.mutable.empty();
        while (iterator.hasNext()) {
            MutableBag batch = Bags.mutable.empty();
            for (int i = 0; i < size && iterator.hasNext(); ++i) {
                batch.add(iterator.next());
            }
            result.add(batch.toImmutable());
        }
        return result.toImmutable();
    }
}

