/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.mutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.DoubleIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.bag.primitive.MutableDoubleBagFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.DoubleBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;
import java.util.stream.DoubleStream;

public class MutableDoubleBagFactoryImpl
implements MutableDoubleBagFactory {
    public static final MutableDoubleBagFactory INSTANCE = new MutableDoubleBagFactoryImpl();

    @Override
    public MutableDoubleBag empty() {
        return new DoubleHashBag();
    }

    @Override
    public MutableDoubleBag of() {
        return this.empty();
    }

    @Override
    public MutableDoubleBag with() {
        return this.empty();
    }

    @Override
    public MutableDoubleBag of(double ... items) {
        return this.with(items);
    }

    @Override
    public MutableDoubleBag with(double ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return DoubleHashBag.newBagWith(items);
    }

    @Override
    public MutableDoubleBag ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableDoubleBag withAll(DoubleIterable items) {
        return DoubleHashBag.newBag(items);
    }

    @Override
    public MutableDoubleBag ofAll(Iterable<Double> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableDoubleBag withAll(Iterable<Double> iterable) {
        return Iterate.collectDouble(iterable, Double::doubleValue, DoubleBags.mutable.empty());
    }

    @Override
    public MutableDoubleBag ofAll(DoubleStream items) {
        return this.withAll(items);
    }

    @Override
    public MutableDoubleBag withAll(DoubleStream items) {
        return this.with(items.toArray());
    }
}

