/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.mutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LongIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.MutableLongBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.bag.primitive.MutableLongBagFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.LongBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;
import java.util.stream.LongStream;

public class MutableLongBagFactoryImpl
implements MutableLongBagFactory {
    public static final MutableLongBagFactory INSTANCE = new MutableLongBagFactoryImpl();

    @Override
    public MutableLongBag empty() {
        return new LongHashBag();
    }

    @Override
    public MutableLongBag of() {
        return this.empty();
    }

    @Override
    public MutableLongBag with() {
        return this.empty();
    }

    @Override
    public MutableLongBag of(long ... items) {
        return this.with(items);
    }

    @Override
    public MutableLongBag with(long ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return LongHashBag.newBagWith(items);
    }

    @Override
    public MutableLongBag ofAll(LongIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableLongBag withAll(LongIterable items) {
        return LongHashBag.newBag(items);
    }

    @Override
    public MutableLongBag ofAll(Iterable<Long> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableLongBag withAll(Iterable<Long> iterable) {
        return Iterate.collectLong(iterable, Long::longValue, LongBags.mutable.empty());
    }

    @Override
    public MutableLongBag ofAll(LongStream items) {
        return this.withAll(items);
    }

    @Override
    public MutableLongBag withAll(LongStream items) {
        return this.with(items.toArray());
    }
}

