/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.sorted.immutable;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.ImmutableBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.MutableBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.sorted.ImmutableSortedBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.sorted.SortedBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ByteFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.CharFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.FloatFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.IntFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.LongFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ShortFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Bags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.SortedBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Stacks;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.BooleanLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.ByteLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.CharLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.DoubleLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.FloatLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.IntLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.LongLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.ShortLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.ImmutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.MutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.ImmutableBooleanList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.ImmutableByteList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.ImmutableCharList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.ImmutableDoubleList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.ImmutableFloatList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.ImmutableIntList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.ImmutableLongList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.ImmutableShortList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.ImmutableMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.multimap.sortedbag.ImmutableSortedBagMultimap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.partition.bag.sorted.PartitionImmutableSortedBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.sorted.ImmutableSortedSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.MutableStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.Pair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.primitive.ObjectIntPair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.immutable.AbstractImmutableBagIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.sorted.immutable.ImmutableSortedBagSerializationProxy;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.factory.Comparators;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.factory.Functions;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.factory.Predicates;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.mutable.FastList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.UnifiedMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.multimap.bag.sorted.mutable.TreeBagMultimap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.partition.bag.sorted.PartitionTreeBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.sorted.mutable.TreeSortedSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.tuple.Tuples;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

abstract class AbstractImmutableSortedBag<T>
extends AbstractImmutableBagIterable<T>
implements ImmutableSortedBag<T> {
    AbstractImmutableSortedBag() {
    }

    @Override
    public ImmutableSortedBag<T> newWithoutAll(Iterable<? extends T> elements) {
        return this.reject(Predicates.in(elements));
    }

    @Override
    public ImmutableSortedBag<T> toImmutable() {
        return this;
    }

    @Override
    public ImmutableSortedBag<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    protected Object writeReplace() {
        return new ImmutableSortedBagSerializationProxy(this);
    }

    @Override
    public <V> ImmutableBag<V> countBy(Function<? super T, ? extends V> function) {
        return this.collect(function, Bags.mutable.empty()).toImmutable();
    }

    @Override
    public <V, P> ImmutableBag<V> countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collectWith(function, parameter, Bags.mutable.empty()).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> countByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.countByEach(function, Bags.mutable.empty()).toImmutable();
    }

    @Override
    public <V> ImmutableSortedBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.groupBy(function, TreeBagMultimap.newMultimap(this.comparator())).toImmutable();
    }

    @Override
    public <V> ImmutableSortedBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.groupByEach(function, TreeBagMultimap.newMultimap(this.comparator())).toImmutable();
    }

    @Override
    public <V> ImmutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.groupByUniqueKey(function, UnifiedMap.newMap(this.size())).toImmutable();
    }

    @Override
    public ImmutableSortedBag<T> select(Predicate<? super T> predicate) {
        return this.select(predicate, SortedBags.mutable.empty(this.comparator())).toImmutable();
    }

    @Override
    public <P> ImmutableSortedBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.selectWith(predicate, parameter, SortedBags.mutable.empty(this.comparator())).toImmutable();
    }

    @Override
    public ImmutableSortedBag<T> reject(Predicate<? super T> predicate) {
        return this.reject(predicate, SortedBags.mutable.empty(this.comparator())).toImmutable();
    }

    @Override
    public <P> ImmutableSortedBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.rejectWith(predicate, parameter, SortedBags.mutable.empty(this.comparator())).toImmutable();
    }

    @Override
    public PartitionImmutableSortedBag<T> partition(Predicate<? super T> predicate) {
        PartitionTreeBag result = new PartitionTreeBag(this.comparator());
        this.forEachWithOccurrences((each, index) -> {
            SortedBag bucket = predicate.accept(each) ? result.getSelected() : result.getRejected();
            bucket.addOccurrences(each, index);
        });
        return result.toImmutable();
    }

    @Override
    public <P> PartitionImmutableSortedBag<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        PartitionTreeBag result = new PartitionTreeBag(this.comparator());
        this.forEachWithOccurrences((each, index) -> {
            SortedBag bucket = predicate.accept((Object)each, (Object)parameter) ? result.getSelected() : result.getRejected();
            bucket.addOccurrences(each, index);
        });
        return result.toImmutable();
    }

    @Override
    public <V> ImmutableList<V> collect(Function<? super T, ? extends V> function) {
        return this.collect(function, FastList.newList()).toImmutable();
    }

    @Override
    public <P, V> ImmutableList<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collectWith(function, parameter, FastList.newList()).toImmutable();
    }

    @Override
    public <V> ImmutableList<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.collectIf(predicate, function, FastList.newList()).toImmutable();
    }

    @Override
    public ImmutableBooleanList collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return this.collectBoolean(booleanFunction, BooleanLists.mutable.withInitialCapacity(this.size())).toImmutable();
    }

    @Override
    public ImmutableByteList collectByte(ByteFunction<? super T> byteFunction) {
        return this.collectByte(byteFunction, ByteLists.mutable.withInitialCapacity(this.size())).toImmutable();
    }

    @Override
    public ImmutableCharList collectChar(CharFunction<? super T> charFunction) {
        return this.collectChar(charFunction, CharLists.mutable.withInitialCapacity(this.size())).toImmutable();
    }

    @Override
    public ImmutableDoubleList collectDouble(DoubleFunction<? super T> doubleFunction) {
        return this.collectDouble(doubleFunction, DoubleLists.mutable.withInitialCapacity(this.size())).toImmutable();
    }

    @Override
    public ImmutableFloatList collectFloat(FloatFunction<? super T> floatFunction) {
        return this.collectFloat(floatFunction, FloatLists.mutable.withInitialCapacity(this.size())).toImmutable();
    }

    @Override
    public ImmutableIntList collectInt(IntFunction<? super T> intFunction) {
        return this.collectInt(intFunction, IntLists.mutable.withInitialCapacity(this.size())).toImmutable();
    }

    @Override
    public ImmutableLongList collectLong(LongFunction<? super T> longFunction) {
        return this.collectLong(longFunction, LongLists.mutable.withInitialCapacity(this.size())).toImmutable();
    }

    @Override
    public ImmutableShortList collectShort(ShortFunction<? super T> shortFunction) {
        return this.collectShort(shortFunction, ShortLists.mutable.withInitialCapacity(this.size())).toImmutable();
    }

    @Override
    public <V> ImmutableList<V> collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        return this.collectWithOccurrences(function, FastList.newList()).toImmutable();
    }

    @Override
    public <V> ImmutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect(function, FastList.newList()).toImmutable();
    }

    @Override
    public ImmutableSortedBag<T> selectByOccurrences(IntPredicate predicate) {
        MutableSortedBag result = SortedBags.mutable.empty(this.comparator());
        this.forEachWithOccurrences((each, occurrences) -> {
            if (predicate.accept(occurrences)) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result.toImmutable();
    }

    @Override
    public <S> ImmutableSortedBag<S> selectInstancesOf(Class<S> clazz) {
        Comparator comparator = this.comparator();
        MutableSortedBag result = SortedBags.mutable.empty(comparator);
        this.forEachWithOccurrences((each, occurrences) -> {
            if (clazz.isInstance(each)) {
                result.addOccurrences(clazz.cast(each), occurrences);
            }
        });
        return result.toImmutable();
    }

    @Override
    public <S> ImmutableList<Pair<T, S>> zip(Iterable<S> that) {
        MutableList<Object> list;
        if (that instanceof Collection || that instanceof RichIterable) {
            int thatSize = Iterate.sizeOf(that);
            list = Lists.mutable.withInitialCapacity(Math.min(this.size(), thatSize));
        } else {
            list = FastList.newList();
        }
        Iterator iterator = that.iterator();
        this.forEachWithOccurrences((each, parameter) -> {
            for (int i = 0; i < parameter; ++i) {
                if (!iterator.hasNext()) continue;
                list.add(Tuples.pair(each, iterator.next()));
            }
        });
        return list.toImmutable();
    }

    @Override
    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
        Iterator iterator = that.iterator();
        if (target instanceof MutableBag) {
            MutableBag targetBag = (MutableBag)target;
            this.forEachWithOccurrences((each, occurrences) -> {
                if (iterator.hasNext()) {
                    targetBag.addOccurrences(Tuples.pair(each, iterator.next()), occurrences);
                }
            });
        } else {
            this.forEachWithOccurrences((each, occurrences) -> {
                for (int i = 0; i < occurrences; ++i) {
                    if (!iterator.hasNext()) continue;
                    target.add(Tuples.pair(each, iterator.next()));
                }
            });
        }
        return target;
    }

    @Override
    public ImmutableSortedSet<Pair<T, Integer>> zipWithIndex() {
        Comparator comparator = this.comparator() == null ? Comparators.naturalOrder() : this.comparator();
        TreeSortedSet pairs = TreeSortedSet.newSet(Comparators.chain(Comparators.byFunction(Functions.firstOfPair(), comparator), Comparators.byFunction(Functions.secondOfPair())));
        return Iterate.zipWithIndex(this, pairs).toImmutable();
    }

    @Override
    public ImmutableList<ObjectIntPair<T>> topOccurrences(int n) {
        return this.occurrencesSortingBy(n, item -> -item.getTwo()).toImmutable();
    }

    @Override
    public ImmutableList<ObjectIntPair<T>> bottomOccurrences(int n) {
        return this.occurrencesSortingBy(n, ObjectIntPair::getTwo).toImmutable();
    }

    private MutableList<ObjectIntPair<T>> occurrencesSortingBy(int n, IntFunction<ObjectIntPair<T>> function) {
        int keySize;
        if (n < 0) {
            throw new IllegalArgumentException("Cannot use a value of n < 0");
        }
        if (n == 0) {
            return Lists.fixedSize.empty();
        }
        MutableList<ObjectIntPair<T>> sorted = this.toListWithOccurrences().sortThisByInt(function);
        MutableList<ObjectIntPair<T>> results = sorted.subList(0, keySize).toList();
        for (keySize = Math.min(n, this.sizeDistinct()); keySize < sorted.size() && ((ObjectIntPair)results.getLast()).getTwo() == ((ObjectIntPair)sorted.get(keySize)).getTwo(); ++keySize) {
            results.add(sorted.get(keySize));
        }
        return results;
    }

    @Override
    public MutableStack<T> toStack() {
        return Stacks.mutable.withAll(this);
    }

    @Override
    public RichIterable<RichIterable<T>> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        Object[] objects = this.toArray();
        MutableSortedBag batch = SortedBags.mutable.empty(this.comparator());
        int j = 0;
        while (j < objects.length) {
            for (int i = 0; i < size && j < objects.length; ++j, ++i) {
                batch.add(objects[j]);
            }
            result.add(batch.toImmutable());
        }
        return result.toImmutable();
    }

    @Override
    public ImmutableSortedBag<T> toReversed() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toReversed() not implemented yet");
    }

    @Override
    public int detectLastIndex(Predicate<? super T> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".detectLastIndex() not implemented yet");
    }

    @Override
    public LazyIterable<T> asReversed() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".asReversed() not implemented yet");
    }
}

