/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.sorted.immutable;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.sorted.ImmutableSortedBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.sorted.SortedBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.SortedBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.bag.sorted.ImmutableSortedBagFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.sorted.immutable.ImmutableEmptySortedBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.sorted.immutable.ImmutableSortedBagImpl;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.sorted.mutable.TreeBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;
import java.util.Comparator;

public class ImmutableSortedBagFactoryImpl
implements ImmutableSortedBagFactory {
    public static final ImmutableSortedBagFactory INSTANCE = new ImmutableSortedBagFactoryImpl();

    @Override
    public <T> ImmutableSortedBag<T> empty() {
        return ImmutableEmptySortedBag.INSTANCE;
    }

    @Override
    public <T> ImmutableSortedBag<T> empty(Comparator<? super T> comparator) {
        return new ImmutableEmptySortedBag<T>(comparator);
    }

    @Override
    public <T> ImmutableSortedBag<T> of() {
        return this.with();
    }

    @Override
    public <T> ImmutableSortedBag<T> with() {
        return this.empty();
    }

    @Override
    public <T> ImmutableSortedBag<T> of(T ... items) {
        return this.with(items);
    }

    @Override
    public <T> ImmutableSortedBag<T> with(T ... items) {
        if (items == null || items.length == 0) {
            return this.of();
        }
        return new ImmutableSortedBagImpl<T>(TreeBag.newBagWith(items));
    }

    @Override
    public <T> ImmutableSortedBag<T> ofAll(Iterable<? extends T> items) {
        return this.withAll(items);
    }

    @Override
    public <T> ImmutableSortedBag<T> withAll(Iterable<? extends T> items) {
        if (items instanceof ImmutableSortedBag) {
            return (ImmutableSortedBag)items;
        }
        if (Iterate.isEmpty(items)) {
            return this.empty();
        }
        return new ImmutableSortedBagImpl<T>(SortedBags.mutable.withAll(items));
    }

    @Override
    public <T> ImmutableSortedBag<T> of(Comparator<? super T> comparator) {
        return this.with(comparator);
    }

    @Override
    public <T> ImmutableSortedBag<T> with(Comparator<? super T> comparator) {
        if (comparator == null) {
            return this.of();
        }
        return new ImmutableEmptySortedBag<T>(comparator);
    }

    @Override
    public <T> ImmutableSortedBag<T> of(Comparator<? super T> comparator, T ... items) {
        return this.with(comparator, items);
    }

    @Override
    public <T> ImmutableSortedBag<T> with(Comparator<? super T> comparator, T ... items) {
        if (items == null || items.length == 0) {
            return this.of(comparator);
        }
        return new ImmutableSortedBagImpl<T>(TreeBag.newBagWith(comparator, items));
    }

    @Override
    public <T> ImmutableSortedBag<T> ofAll(Comparator<? super T> comparator, Iterable<? extends T> items) {
        return this.withAll(comparator, items);
    }

    @Override
    public <T> ImmutableSortedBag<T> withAll(Comparator<? super T> comparator, Iterable<? extends T> items) {
        if (Iterate.isEmpty(items)) {
            return this.of(comparator);
        }
        return new ImmutableSortedBagImpl<T>(SortedBags.mutable.withAll(comparator, items));
    }

    @Override
    public <T> ImmutableSortedBag<T> ofSortedBag(SortedBag<T> bag) {
        return this.withSortedBag(bag);
    }

    @Override
    public <T> ImmutableSortedBag<T> withSortedBag(SortedBag<T> bag) {
        if (bag instanceof ImmutableSortedBag) {
            return (ImmutableSortedBag)bag;
        }
        if (bag.isEmpty()) {
            return this.of(bag.comparator());
        }
        return new ImmutableSortedBagImpl<T>(bag);
    }
}

