/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collection.mutable;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.ImmutableCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.MutableCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Sets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.MutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.MutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.CollectionAddProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.CollectionRemoveProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collection.mutable.AbstractCollectionAdapter;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collection.mutable.SynchronizedMutableCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collection.mutable.UnmodifiableMutableCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.mutable.ArrayListAdapter;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.mutable.ListAdapter;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.mutable.RandomAccessListAdapter;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.SetAdapter;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.ArrayIterate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;

public final class CollectionAdapter<T>
extends AbstractCollectionAdapter<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Collection<T> delegate;

    public CollectionAdapter(Collection<T> newDelegate) {
        if (newDelegate == null) {
            throw new NullPointerException("CollectionAdapter may not wrap null");
        }
        this.delegate = newDelegate;
    }

    @Override
    protected Collection<T> getDelegate() {
        return this.delegate;
    }

    @Override
    public MutableCollection<T> asUnmodifiable() {
        return UnmodifiableMutableCollection.of(this);
    }

    @Override
    public MutableCollection<T> asSynchronized() {
        return SynchronizedMutableCollection.of(this);
    }

    @Override
    public ImmutableCollection<T> toImmutable() {
        return this.delegate instanceof Set ? Sets.immutable.withAll(this.delegate) : Lists.immutable.withAll(this.delegate);
    }

    public static <E> MutableSet<E> wrapSet(Iterable<E> iterable) {
        if (iterable instanceof MutableSet) {
            return (MutableSet)iterable;
        }
        if (iterable instanceof Set) {
            return SetAdapter.adapt((Set)iterable);
        }
        return Sets.mutable.withAll(iterable);
    }

    public static <E> MutableList<E> wrapList(Iterable<E> iterable) {
        if (iterable instanceof MutableList) {
            return (MutableList)iterable;
        }
        if (iterable instanceof ArrayList) {
            return ArrayListAdapter.adapt((ArrayList)iterable);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListAdapter.adapt((List)iterable);
        }
        if (iterable instanceof List) {
            return ListAdapter.adapt((List)iterable);
        }
        return Lists.mutable.withAll(iterable);
    }

    public static <E> MutableCollection<E> adapt(Collection<E> collection) {
        if (collection instanceof MutableCollection) {
            return (MutableCollection)collection;
        }
        if (collection instanceof List) {
            return CollectionAdapter.wrapList(collection);
        }
        if (collection instanceof Set) {
            return SetAdapter.adapt((Set)collection);
        }
        return new CollectionAdapter<E>(collection);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionAdapter that = (CollectionAdapter)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public CollectionAdapter<T> with(T ... elements) {
        ArrayIterate.forEach(elements, new CollectionAddProcedure<T>(this.delegate));
        return this;
    }

    @Override
    public CollectionAdapter<T> with(T element) {
        this.delegate.add(element);
        return this;
    }

    @Override
    public CollectionAdapter<T> without(T element) {
        this.delegate.remove(element);
        return this;
    }

    @Override
    public CollectionAdapter<T> withAll(Iterable<? extends T> elements) {
        Iterate.forEach(elements, new CollectionAddProcedure<T>(this.delegate));
        return this;
    }

    @Override
    public CollectionAdapter<T> withoutAll(Iterable<? extends T> elements) {
        Iterate.forEach(elements, new CollectionRemoveProcedure<T>(this.delegate));
        return this;
    }

    @Override
    @Deprecated
    public MutableCollection<T> newEmpty() {
        if (this.delegate instanceof Set) {
            return Sets.mutable.empty();
        }
        return Lists.mutable.empty();
    }
}

