/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collection.mutable;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.ImmutableCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.MutableCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collection.mutable.AbstractSynchronizedMutableCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collection.mutable.CollectionAdapter;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collection.mutable.SynchronizedCollectionSerializationProxy;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collection.mutable.UnmodifiableMutableCollection;
import java.io.Serializable;
import java.util.Collection;

public class SynchronizedMutableCollection<T>
extends AbstractSynchronizedMutableCollection<T>
implements Serializable {
    private static final long serialVersionUID = 2L;

    SynchronizedMutableCollection(MutableCollection<T> newCollection) {
        this(newCollection, (Object)null);
    }

    SynchronizedMutableCollection(MutableCollection<T> newCollection, Object newLock) {
        super(newCollection, newLock);
    }

    public static <E, C extends Collection<E>> SynchronizedMutableCollection<E> of(C collection) {
        return new SynchronizedMutableCollection(CollectionAdapter.adapt(collection));
    }

    public static <E, C extends Collection<E>> SynchronizedMutableCollection<E> of(C collection, Object lock) {
        return new SynchronizedMutableCollection(CollectionAdapter.adapt(collection), lock);
    }

    protected Object writeReplace() {
        return new SynchronizedCollectionSerializationProxy(this.getDelegate());
    }

    @Override
    public MutableCollection<T> with(T element) {
        this.add(element);
        return this;
    }

    @Override
    public MutableCollection<T> without(T element) {
        this.remove(element);
        return this;
    }

    @Override
    public MutableCollection<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    @Override
    public MutableCollection<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCollection<T> asUnmodifiable() {
        Object object = this.lock;
        synchronized (object) {
            return new UnmodifiableMutableCollection(this);
        }
    }

    @Override
    public MutableCollection<T> asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableCollection<T> toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().toImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCollection<T> newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().newEmpty().asSynchronized();
        }
    }
}

