/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collector;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Optional;

public class BigIntegerSummaryStatistics
implements Procedure<BigInteger> {
    private static final long serialVersionUID = 1L;
    private long count;
    private BigInteger sum = BigInteger.ZERO;
    private BigInteger min;
    private BigInteger max;

    @Override
    public void value(BigInteger each) {
        ++this.count;
        if (each != null) {
            this.sum = this.sum.add(each);
            this.min = this.min == null ? each : this.min.min(each);
            this.max = this.max == null ? each : this.max.max(each);
        }
    }

    public long getCount() {
        return this.count;
    }

    public BigInteger getSum() {
        return this.sum;
    }

    public BigInteger getMin() {
        return this.min;
    }

    public Optional<BigInteger> getMinOptional() {
        return Optional.ofNullable(this.min);
    }

    public BigInteger getMax() {
        return this.max;
    }

    public Optional<BigInteger> getMaxOptional() {
        return Optional.ofNullable(this.max);
    }

    public BigDecimal getAverage(MathContext context) {
        return this.count == 0L ? BigDecimal.ZERO : new BigDecimal(this.getSum()).divide(BigDecimal.valueOf(this.count), context);
    }

    public BigDecimal getAverage() {
        return this.getAverage(MathContext.DECIMAL128);
    }

    public BigIntegerSummaryStatistics merge(BigIntegerSummaryStatistics summaryStatistics) {
        this.count += summaryStatistics.count;
        this.sum = this.sum.add(summaryStatistics.sum);
        if (summaryStatistics.min != null) {
            BigInteger bigInteger = this.min = this.min == null ? summaryStatistics.min : this.min.min(summaryStatistics.min);
        }
        if (summaryStatistics.max != null) {
            this.max = this.max == null ? summaryStatistics.max : this.max.max(summaryStatistics.max);
        }
        return this;
    }
}

