/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.iterator;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function0;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.MutableCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Lists;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ChunkIterator<T>
implements Iterator<RichIterable<T>> {
    private final Iterator<T> iterator;
    private final int size;
    private final Function0<MutableCollection<T>> speciesNewStrategy;

    public ChunkIterator(Iterable<T> iterable, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        this.size = size;
        this.iterator = iterable.iterator();
        this.speciesNewStrategy = iterable instanceof MutableCollection ? ((MutableCollection)iterable)::newEmpty : Lists.mutable::empty;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public RichIterable<T> next() {
        if (!this.iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        MutableCollection<T> result = this.speciesNewStrategy.value();
        for (int i = this.size; i > 0 && this.iterator.hasNext(); --i) {
            result.add(this.iterator.next());
        }
        return result;
    }
}

