/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class TakeIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final int count;
    private int currentIndex;

    public TakeIterator(Iterable<T> iterable, int count) {
        this(iterable.iterator(), count);
    }

    public TakeIterator(Iterator<T> iterator, int count) {
        this.iterator = iterator;
        this.count = count;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.count && this.iterator.hasNext();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            ++this.currentIndex;
            return this.iterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a take iterator");
    }
}

