/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.ParallelIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.MutableBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function0;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.FloatFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.IntFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.LongFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.MutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.ParallelListIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.MapIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.MutableMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.sorted.MutableSortedMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.MutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.sorted.MutableSortedSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel.MultiReaderParallelIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel.list.MultiReaderParallelListIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel.set.MultiReaderParallelUnsortedSetIterable;
import java.util.Comparator;
import java.util.concurrent.locks.ReadWriteLock;

public abstract class AbstractMultiReaderParallelIterable<T, PI extends ParallelIterable<T>>
implements ParallelIterable<T> {
    protected final PI delegate;
    protected final ReadWriteLock lock;

    protected AbstractMultiReaderParallelIterable(PI delegate, ReadWriteLock lock) {
        this.delegate = delegate;
        this.lock = lock;
    }

    protected <A> ParallelListIterable<A> wrap(ParallelListIterable<A> wrapped) {
        return new MultiReaderParallelListIterable<A>(wrapped, this.lock);
    }

    protected <A> ParallelUnsortedSetIterable<A> wrap(ParallelUnsortedSetIterable<A> wrapped) {
        return new MultiReaderParallelUnsortedSetIterable<A>(wrapped, this.lock);
    }

    protected <A> ParallelIterable<A> wrap(ParallelIterable<A> wrapped) {
        return new MultiReaderParallelIterable<A>(wrapped, this.lock);
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        this.lock.readLock().lock();
        try {
            this.delegate.forEach(procedure);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        this.lock.readLock().lock();
        try {
            this.delegate.forEachWith(procedure, parameter);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        this.lock.readLock().lock();
        try {
            T t2 = this.delegate.detect(predicate);
            return t2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.lock.readLock().lock();
        try {
            T t2 = this.delegate.detectWith(predicate, parameter);
            return t2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        this.lock.readLock().lock();
        try {
            T t2 = this.delegate.detectIfNone(predicate, function);
            return t2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> T detectWithIfNone(Predicate2<? super T, ? super P> predicate, P parameter, Function0<? extends T> function) {
        this.lock.readLock().lock();
        try {
            T t2 = this.delegate.detectWithIfNone(predicate, parameter, function);
            return t2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int count(Predicate<? super T> predicate) {
        this.lock.readLock().lock();
        try {
            int n = this.delegate.count(predicate);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> int countWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.lock.readLock().lock();
        try {
            int n = this.delegate.countWith(predicate, parameter);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.anySatisfy(predicate);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.anySatisfyWith(predicate, parameter);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.allSatisfy(predicate);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.allSatisfyWith(predicate, parameter);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.noneSatisfy(predicate);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.noneSatisfyWith(predicate, parameter);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public MutableList<T> toList() {
        this.lock.readLock().lock();
        try {
            MutableList mutableList = this.delegate.toList();
            return mutableList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public MutableList<T> toSortedList() {
        this.lock.readLock().lock();
        try {
            MutableList mutableList = this.delegate.toSortedList();
            return mutableList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public MutableList<T> toSortedList(Comparator<? super T> comparator) {
        this.lock.readLock().lock();
        try {
            MutableList<? super T> mutableList = this.delegate.toSortedList(comparator);
            return mutableList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <V extends Comparable<? super V>> MutableList<T> toSortedListBy(Function<? super T, ? extends V> function) {
        this.lock.readLock().lock();
        try {
            MutableList<? super T> mutableList = this.delegate.toSortedListBy(function);
            return mutableList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public MutableSet<T> toSet() {
        this.lock.readLock().lock();
        try {
            MutableSet mutableSet = this.delegate.toSet();
            return mutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public MutableSortedSet<T> toSortedSet() {
        this.lock.readLock().lock();
        try {
            MutableSortedSet mutableSortedSet = this.delegate.toSortedSet();
            return mutableSortedSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        this.lock.readLock().lock();
        try {
            MutableSortedSet<? super T> mutableSortedSet = this.delegate.toSortedSet(comparator);
            return mutableSortedSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <V extends Comparable<? super V>> MutableSortedSet<T> toSortedSetBy(Function<? super T, ? extends V> function) {
        this.lock.readLock().lock();
        try {
            MutableSortedSet<? super T> mutableSortedSet = this.delegate.toSortedSetBy(function);
            return mutableSortedSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public MutableBag<T> toBag() {
        this.lock.readLock().lock();
        try {
            MutableBag mutableBag = this.delegate.toBag();
            return mutableBag;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public MutableSortedBag<T> toSortedBag() {
        this.lock.readLock().lock();
        try {
            MutableSortedBag mutableSortedBag = this.delegate.toSortedBag();
            return mutableSortedBag;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public MutableSortedBag<T> toSortedBag(Comparator<? super T> comparator) {
        this.lock.readLock().lock();
        try {
            MutableSortedBag<? super T> mutableSortedBag = this.delegate.toSortedBag(comparator);
            return mutableSortedBag;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <V extends Comparable<? super V>> MutableSortedBag<T> toSortedBagBy(Function<? super T, ? extends V> function) {
        this.lock.readLock().lock();
        try {
            MutableSortedBag<? super T> mutableSortedBag = this.delegate.toSortedBagBy(function);
            return mutableSortedBag;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        this.lock.readLock().lock();
        try {
            MutableMap<? extends NK, ? extends NV> mutableMap = this.delegate.toMap(keyFunction, valueFunction);
            return mutableMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        this.lock.readLock().lock();
        try {
            MutableSortedMap<? extends NK, ? extends NV> mutableSortedMap = this.delegate.toSortedMap(keyFunction, valueFunction);
            return mutableSortedMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        this.lock.readLock().lock();
        try {
            MutableSortedMap<? extends NK, ? extends NV> mutableSortedMap = this.delegate.toSortedMap(comparator, keyFunction, valueFunction);
            return mutableSortedMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Object[] toArray() {
        this.lock.readLock().lock();
        try {
            Object[] objectArray = this.delegate.toArray();
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <T1> T1[] toArray(T1[] target) {
        this.lock.readLock().lock();
        try {
            T1[] T1Array = this.delegate.toArray(target);
            return T1Array;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public T min(Comparator<? super T> comparator) {
        this.lock.readLock().lock();
        try {
            T t2 = this.delegate.min(comparator);
            return t2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public T max(Comparator<? super T> comparator) {
        this.lock.readLock().lock();
        try {
            T t2 = this.delegate.max(comparator);
            return t2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public T min() {
        this.lock.readLock().lock();
        try {
            Object t2 = this.delegate.min();
            return t2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public T max() {
        this.lock.readLock().lock();
        try {
            Object t2 = this.delegate.max();
            return t2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        this.lock.readLock().lock();
        try {
            T t2 = this.delegate.minBy(function);
            return t2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        this.lock.readLock().lock();
        try {
            T t2 = this.delegate.maxBy(function);
            return t2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sumOfInt(IntFunction<? super T> function) {
        this.lock.readLock().lock();
        try {
            long l = this.delegate.sumOfInt(function);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double sumOfFloat(FloatFunction<? super T> function) {
        this.lock.readLock().lock();
        try {
            double d = this.delegate.sumOfFloat(function);
            return d;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sumOfLong(LongFunction<? super T> function) {
        this.lock.readLock().lock();
        try {
            long l = this.delegate.sumOfLong(function);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double sumOfDouble(DoubleFunction<? super T> function) {
        this.lock.readLock().lock();
        try {
            double d = this.delegate.sumOfDouble(function);
            return d;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public String makeString() {
        this.lock.readLock().lock();
        try {
            String string = this.delegate.makeString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public String makeString(String separator) {
        this.lock.readLock().lock();
        try {
            String string = this.delegate.makeString(separator);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String start, String separator, String end) {
        this.lock.readLock().lock();
        try {
            String string = this.delegate.makeString(start, separator, end);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(Function<? super T, Object> function, String start, String separator, String end) {
        this.lock.readLock().lock();
        try {
            String string = this.delegate.makeString(function, start, separator, end);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void appendString(Appendable appendable) {
        this.lock.readLock().lock();
        try {
            this.delegate.appendString(appendable);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.lock.readLock().lock();
        try {
            this.delegate.appendString(appendable, separator);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.lock.readLock().lock();
        try {
            this.delegate.appendString(appendable, start, separator, end);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <V> MapIterable<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        this.lock.readLock().lock();
        try {
            MapIterable<? extends V, ? super T> mapIterable = this.delegate.groupByUniqueKey(function);
            return mapIterable;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> MapIterable<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        this.lock.readLock().lock();
        try {
            MapIterable<? extends K, ? super V> mapIterable = this.delegate.aggregateInPlaceBy(groupBy, zeroValueFactory, mutatingAggregator);
            return mapIterable;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> MapIterable<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        this.lock.readLock().lock();
        try {
            MapIterable<? extends K, ? extends V> mapIterable = this.delegate.aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator);
            return mapIterable;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        this.lock.readLock().lock();
        try {
            String string = this.delegate.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

