/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.ParallelIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.annotation.Beta;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.multimap.bag.UnsortedBagMultimap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.factory.Functions;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.factory.Predicates;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel.Batch;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel.ParallelDistinctIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel.ParallelSelectIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel.set.ParallelCollectIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel.set.ParallelFlatCollectIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.multimap.bag.SynchronizedPutHashBagMultimap;

@Beta
public abstract class AbstractParallelIterableImpl<T, B extends Batch<T>>
extends AbstractParallelIterable<T, B> {
    @Override
    protected boolean isOrdered() {
        return false;
    }

    @Override
    public ParallelUnsortedSetIterable<T> asUnique() {
        return new ParallelDistinctIterable(this);
    }

    @Override
    public ParallelIterable<T> select(Predicate<? super T> predicate) {
        return new ParallelSelectIterable<T>(this, predicate);
    }

    @Override
    public <P> ParallelIterable<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.select(Predicates.bind(predicate, parameter));
    }

    @Override
    public <S> ParallelIterable<S> selectInstancesOf(Class<S> clazz) {
        return this.select(Predicates.instanceOf(clazz));
    }

    @Override
    public ParallelIterable<T> reject(Predicate<? super T> predicate) {
        return this.select(Predicates.not(predicate));
    }

    @Override
    public <P> ParallelIterable<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.reject(Predicates.bind(predicate, parameter));
    }

    @Override
    public <V> ParallelIterable<V> collect(Function<? super T, ? extends V> function) {
        return new ParallelCollectIterable<T, V>(this, function);
    }

    @Override
    public <P, V> ParallelIterable<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collect(Functions.bind(function, parameter));
    }

    @Override
    public <V> ParallelIterable<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.select(predicate).collect(function);
    }

    @Override
    public <V> ParallelIterable<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return new ParallelFlatCollectIterable(this, function);
    }

    @Override
    public <V> UnsortedBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        SynchronizedPutHashBagMultimap result = SynchronizedPutHashBagMultimap.newMultimap();
        this.forEach(each -> {
            Object key = function.valueOf(each);
            result.put(key, each);
        });
        return result;
    }

    @Override
    public <V> UnsortedBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        SynchronizedPutHashBagMultimap result = SynchronizedPutHashBagMultimap.newMultimap();
        this.forEach(each -> {
            Iterable keys = (Iterable)function.valueOf(each);
            for (Object key : keys) {
                result.put(key, each);
            }
        });
        return result;
    }
}

