/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.annotation.Beta;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.factory.Predicates;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.IfProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterableImpl;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.parallel.Batch;
import java.util.concurrent.ExecutorService;

@Beta
public class ParallelSelectIterable<T>
extends AbstractParallelIterableImpl<T, Batch<T>> {
    private final AbstractParallelIterable<T, ? extends Batch<T>> parallelIterable;
    private final Predicate<? super T> predicate;

    public ParallelSelectIterable(AbstractParallelIterable<T, ? extends Batch<T>> parallelIterable, Predicate<? super T> predicate) {
        this.parallelIterable = parallelIterable;
        this.predicate = predicate;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.parallelIterable.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.parallelIterable.getBatchSize();
    }

    @Override
    public LazyIterable<Batch<T>> split() {
        return this.parallelIterable.split().collect((T eachBatch) -> eachBatch.select(this.predicate));
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        this.parallelIterable.forEach(new IfProcedure<T>(this.predicate, procedure));
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return this.parallelIterable.anySatisfy(Predicates.and(this.predicate, predicate));
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return this.parallelIterable.allSatisfy(new SelectAllSatisfyPredicate(this.predicate, predicate));
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return this.parallelIterable.detect(Predicates.and(this.predicate, predicate));
    }

    @Override
    public Object[] toArray() {
        return this.parallelIterable.toList().select((Predicate)this.predicate).toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.parallelIterable.toList().select((Predicate)this.predicate).toArray((T[])array);
    }

    private static final class SelectAllSatisfyPredicate<T>
    implements Predicate<T> {
        private final Predicate<? super T> left;
        private final Predicate<? super T> right;

        private SelectAllSatisfyPredicate(Predicate<? super T> left, Predicate<? super T> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean accept(T each) {
            boolean leftResult = this.left.accept(each);
            return !leftResult || this.right.accept(each);
        }
    }
}

