/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.CharIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function0;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.CharLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.CharIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.internal.IterableIterate;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ChunkCharIterable
extends AbstractLazyIterable<CharIterable> {
    private final CharIterable adapted;
    private final int size;

    public ChunkCharIterable(CharIterable delegate, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        this.adapted = delegate;
        this.size = size;
    }

    @Override
    public Iterator<CharIterable> iterator() {
        return new ChunkCharIterator(this.adapted, this.size);
    }

    @Override
    public void each(Procedure<? super CharIterable> procedure) {
        IterableIterate.forEach(this, procedure);
    }

    public static class ChunkCharIterator
    implements Iterator<CharIterable> {
        private final CharIterator iterator;
        private final int size;
        private final Function0<MutableCharCollection> speciesNewStrategy;

        public ChunkCharIterator(CharIterable iterable, int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
            }
            this.size = size;
            this.iterator = iterable.charIterator();
            this.speciesNewStrategy = iterable instanceof MutableCharCollection ? ((MutableCharCollection)iterable)::newEmpty : CharLists.mutable::empty;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public CharIterable next() {
            if (!this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            MutableCharCollection result = this.speciesNewStrategy.value();
            for (int i = this.size; i > 0 && this.iterator.hasNext(); --i) {
                result.add(this.iterator.next());
            }
            return result;
        }
    }
}

