/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.IntIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function0;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.IntLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.IntIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.internal.IterableIterate;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ChunkIntIterable
extends AbstractLazyIterable<IntIterable> {
    private final IntIterable adapted;
    private final int size;

    public ChunkIntIterable(IntIterable delegate, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        this.adapted = delegate;
        this.size = size;
    }

    @Override
    public Iterator<IntIterable> iterator() {
        return new ChunkIntIterator(this.adapted, this.size);
    }

    @Override
    public void each(Procedure<? super IntIterable> procedure) {
        IterableIterate.forEach(this, procedure);
    }

    public static class ChunkIntIterator
    implements Iterator<IntIterable> {
        private final IntIterator iterator;
        private final int size;
        private final Function0<MutableIntCollection> speciesNewStrategy;

        public ChunkIntIterator(IntIterable iterable, int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
            }
            this.size = size;
            this.iterator = iterable.intIterator();
            this.speciesNewStrategy = iterable instanceof MutableIntCollection ? ((MutableIntCollection)iterable)::newEmpty : IntLists.mutable::empty;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public IntIterable next() {
            if (!this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            MutableIntCollection result = this.speciesNewStrategy.value();
            for (int i = this.size; i > 0 && this.iterator.hasNext(); --i) {
                result.add(this.iterator.next());
            }
            return result;
        }
    }
}

