/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.BooleanIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.BooleanBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.BooleanLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.BooleanSets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.BooleanIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.MutableBooleanList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive.AbstractLazyBooleanIterable;
import java.util.Iterator;

public class CollectBooleanIterable<T>
extends AbstractLazyBooleanIterable {
    private final LazyIterable<T> iterable;
    private final BooleanFunction<? super T> function;
    private final BooleanFunctionToProcedure<T> booleanFunctionToProcedure;

    public CollectBooleanIterable(LazyIterable<T> adapted, BooleanFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.booleanFunctionToProcedure = new BooleanFunctionToProcedure(function);
    }

    @Override
    public BooleanIterator booleanIterator() {
        return new BooleanIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectBooleanIterable.this.iterable.iterator();
            }

            @Override
            public boolean next() {
                return CollectBooleanIterable.this.function.booleanValueOf(this.iterator.next());
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    @Override
    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(BooleanProcedure procedure) {
        this.iterable.forEachWith(this.booleanFunctionToProcedure, procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(BooleanPredicate predicate) {
        return this.iterable.count((? super T each) -> predicate.accept(this.function.booleanValueOf(each)));
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.iterable.anySatisfy((? super T each) -> predicate.accept(this.function.booleanValueOf(each)));
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.iterable.allSatisfy((? super T each) -> predicate.accept(this.function.booleanValueOf(each)));
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        return this.iterable.allSatisfy((? super T each) -> !predicate.accept(this.function.booleanValueOf(each)));
    }

    @Override
    public boolean[] toArray() {
        boolean[] array = new boolean[this.size()];
        this.iterable.forEachWithIndex((each, index) -> {
            array[index] = this.function.booleanValueOf(each);
        });
        return array;
    }

    @Override
    public MutableBooleanList toList() {
        return BooleanLists.mutable.withAll(this);
    }

    @Override
    public MutableBooleanSet toSet() {
        return BooleanSets.mutable.withAll(this);
    }

    @Override
    public MutableBooleanBag toBag() {
        return BooleanBags.mutable.withAll(this);
    }

    @Override
    public boolean containsAll(boolean ... source) {
        for (boolean value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(BooleanIterable source) {
        BooleanIterator iterator = source.booleanIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private static final class BooleanFunctionToProcedure<T>
    implements Procedure2<T, BooleanProcedure> {
        private static final long serialVersionUID = 1L;
        private final BooleanFunction<? super T> function;

        private BooleanFunctionToProcedure(BooleanFunction<? super T> function) {
            this.function = function;
        }

        @Override
        public void value(T each, BooleanProcedure procedure) {
            procedure.value(this.function.booleanValueOf(each));
        }
    }
}

