/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.IntIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.MutableIntBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.IntFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.IntBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.IntLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.IntSets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.IntIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.MutableIntList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableIntSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive.AbstractLazyIntIterable;
import java.util.Arrays;
import java.util.Iterator;

public class CollectIntIterable<T>
extends AbstractLazyIntIterable {
    private final LazyIterable<T> iterable;
    private final IntFunction<? super T> function;
    private final IntFunctionToProcedure<T> intFunctionToProcedure;

    public CollectIntIterable(LazyIterable<T> adapted, IntFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.intFunctionToProcedure = new IntFunctionToProcedure(function);
    }

    @Override
    public IntIterator intIterator() {
        return new IntIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectIntIterable.this.iterable.iterator();
            }

            @Override
            public int next() {
                return CollectIntIterable.this.function.intValueOf(this.iterator.next());
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    @Override
    public void each(IntProcedure procedure) {
        this.iterable.forEachWith(this.intFunctionToProcedure, procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(IntPredicate predicate) {
        return this.iterable.count((? super T each) -> predicate.accept(this.function.intValueOf(each)));
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        return this.iterable.anySatisfy((? super T each) -> predicate.accept(this.function.intValueOf(each)));
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        return this.iterable.allSatisfy((? super T each) -> predicate.accept(this.function.intValueOf(each)));
    }

    @Override
    public int[] toArray() {
        int[] array = new int[this.size()];
        this.iterable.forEachWithIndex((each, index) -> {
            array[index] = this.function.intValueOf(each);
        });
        return array;
    }

    @Override
    public int[] toSortedArray() {
        int[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableIntList toList() {
        return IntLists.mutable.withAll(this);
    }

    @Override
    public MutableIntSet toSet() {
        return IntSets.mutable.withAll(this);
    }

    @Override
    public MutableIntBag toBag() {
        return IntBags.mutable.withAll(this);
    }

    @Override
    public boolean containsAll(int ... source) {
        for (int value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(IntIterable source) {
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private static final class IntFunctionToProcedure<T>
    implements Procedure2<T, IntProcedure> {
        private static final long serialVersionUID = 1L;
        private final IntFunction<? super T> function;

        private IntFunctionToProcedure(IntFunction<? super T> function) {
            this.function = function;
        }

        @Override
        public void value(T each, IntProcedure procedure) {
            procedure.value(this.function.intValueOf(each));
        }
    }
}

