/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.ByteIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyByteIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.MutableByteBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.ByteBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.ByteLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.ByteSets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.ByteIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.ByteList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.MutableByteList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableByteSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive.AbstractLazyByteIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import java.util.NoSuchElementException;

public class ReverseByteIterable
extends AbstractLazyByteIterable {
    private final ByteList adapted;

    public ReverseByteIterable(ByteList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseByteIterable adapt(ByteList byteList) {
        return new ReverseByteIterable(byteList);
    }

    @Override
    public ByteIterator byteIterator() {
        return new ReverseByteIterator();
    }

    @Override
    public void each(ByteProcedure procedure) {
        ByteIterator iterator = this.byteIterator();
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    @Override
    public long sum() {
        return this.adapted.sum();
    }

    @Override
    public byte max() {
        return this.adapted.max();
    }

    @Override
    public byte min() {
        return this.adapted.min();
    }

    @Override
    public byte minIfEmpty(byte defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.min();
    }

    @Override
    public byte maxIfEmpty(byte defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.max();
    }

    @Override
    public double average() {
        return this.adapted.average();
    }

    @Override
    public double median() {
        return this.adapted.median();
    }

    @Override
    public byte[] toSortedArray() {
        return this.adapted.toSortedArray();
    }

    @Override
    public byte[] toArray() {
        byte[] results = new byte[this.adapted.size()];
        int index = 0;
        ByteIterator iterator = this.byteIterator();
        while (iterator.hasNext()) {
            results[index] = iterator.next();
            ++index;
        }
        return results;
    }

    @Override
    public boolean contains(byte value) {
        return this.adapted.contains(value);
    }

    @Override
    public boolean containsAll(byte ... source) {
        return this.adapted.containsAll(source);
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        return this.adapted.containsAll(source);
    }

    @Override
    public int size() {
        return this.adapted.size();
    }

    @Override
    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    @Override
    public MutableByteList toList() {
        return ByteLists.mutable.withAll(this);
    }

    @Override
    public MutableByteSet toSet() {
        return ByteSets.mutable.withAll(this);
    }

    @Override
    public MutableByteBag toBag() {
        return ByteBags.mutable.withAll(this);
    }

    @Override
    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter(this);
    }

    private class ReverseByteIterator
    implements ByteIterator {
        private int currentIndex;

        private ReverseByteIterator() {
            this.currentIndex = ReverseByteIterable.this.adapted.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        @Override
        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte next = ReverseByteIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

