/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.BooleanIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.BooleanIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive.AbstractLazyBooleanIterable;

public class TapBooleanIterable
extends AbstractLazyBooleanIterable {
    private final BooleanIterable adapted;
    private final BooleanProcedure procedure;

    public TapBooleanIterable(BooleanIterable delegate, BooleanProcedure procedure) {
        this.adapted = delegate;
        this.procedure = procedure;
    }

    @Override
    public void each(BooleanProcedure procedure) {
        this.adapted.forEach(each -> {
            this.procedure.value(each);
            procedure.value(each);
        });
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.adapted.anySatisfy(each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.adapted.allSatisfy(each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        return this.adapted.noneSatisfy(each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return this.adapted.detectIfNone(each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        }, ifNone);
    }

    @Override
    public BooleanIterator booleanIterator() {
        return new TapBooleanIterator(this.adapted, this.procedure);
    }

    public static class TapBooleanIterator
    implements BooleanIterator {
        private final BooleanIterator iterator;
        private final BooleanProcedure procedure;

        public TapBooleanIterator(BooleanIterable iterable, BooleanProcedure procedure) {
            this(iterable.booleanIterator(), procedure);
        }

        public TapBooleanIterator(BooleanIterator iterator, BooleanProcedure procedure) {
            this.iterator = iterator;
            this.procedure = procedure;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public boolean next() {
            boolean next = this.iterator.next();
            this.procedure.value(next);
            return next;
        }
    }
}

