/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.immutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.IntIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.list.primitive.ImmutableIntListFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.ImmutableIntList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.IntLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.immutable.primitive.ImmutableIntArrayList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.immutable.primitive.ImmutableIntEmptyList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.immutable.primitive.ImmutableIntSingletonList;
import java.util.stream.IntStream;

public class ImmutableIntListFactoryImpl
implements ImmutableIntListFactory {
    public static final ImmutableIntListFactory INSTANCE = new ImmutableIntListFactoryImpl();

    @Override
    public ImmutableIntList empty() {
        return ImmutableIntEmptyList.INSTANCE;
    }

    @Override
    public ImmutableIntList of() {
        return this.empty();
    }

    @Override
    public ImmutableIntList with() {
        return this.empty();
    }

    @Override
    public ImmutableIntList of(int one) {
        return this.with(one);
    }

    @Override
    public ImmutableIntList with(int one) {
        return new ImmutableIntSingletonList(one);
    }

    @Override
    public ImmutableIntList of(int ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableIntList with(int ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableIntArrayList.newListWith(items);
    }

    @Override
    public ImmutableIntList ofAll(IntIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableIntList withAll(IntIterable items) {
        if (items instanceof ImmutableIntList) {
            return (ImmutableIntList)items;
        }
        if (items == null || items.size() == 0) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray()[0]);
        }
        return ImmutableIntArrayList.newList(items);
    }

    @Override
    public ImmutableIntList ofAll(Iterable<Integer> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableIntList withAll(Iterable<Integer> iterable) {
        return IntLists.mutable.withAll(iterable).toImmutable();
    }

    @Override
    public ImmutableIntList ofAll(IntStream items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableIntList withAll(IntStream items) {
        return this.with(items.toArray());
    }
}

