/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.mutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.DoubleIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.list.primitive.MutableDoubleListFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.MutableDoubleList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.DoubleLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;
import java.util.stream.DoubleStream;

public class MutableDoubleListFactoryImpl
implements MutableDoubleListFactory {
    public static final MutableDoubleListFactory INSTANCE = new MutableDoubleListFactoryImpl();

    @Override
    public MutableDoubleList empty() {
        return new DoubleArrayList();
    }

    @Override
    public MutableDoubleList of() {
        return this.empty();
    }

    @Override
    public MutableDoubleList with() {
        return this.empty();
    }

    @Override
    public MutableDoubleList withInitialCapacity(int capacity) {
        return new DoubleArrayList(capacity);
    }

    @Override
    public MutableDoubleList of(double ... items) {
        return this.with(items);
    }

    @Override
    public MutableDoubleList with(double ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return DoubleArrayList.newListWith(items);
    }

    @Override
    public MutableDoubleList ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableDoubleList withAll(DoubleIterable items) {
        return DoubleArrayList.newList(items);
    }

    @Override
    public MutableDoubleList ofAll(Iterable<Double> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableDoubleList withAll(Iterable<Double> iterable) {
        return Iterate.collectDouble(iterable, Double::doubleValue, DoubleLists.mutable.empty());
    }

    @Override
    public MutableDoubleList ofAll(DoubleStream items) {
        return this.withAll(items);
    }

    @Override
    public MutableDoubleList withAll(DoubleStream items) {
        return this.with(items.toArray());
    }
}

