/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.immutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.ByteIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.DoubleIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyByteIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyDoubleIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.ImmutableBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.ByteDoublePredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.ByteDoubleProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.ByteIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.DoubleIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.MutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.MutableDoubleList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.ByteDoubleMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.ImmutableByteDoubleMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.ImmutableDoubleByteMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.MutableByteDoubleMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.MutableDoubleByteMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableByteSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.primitive.ByteDoublePair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedByteDoubleProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.DoubleBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.DoubleByteMaps;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.ByteDoubleHashMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

final class ImmutableByteDoubleHashMap
implements ImmutableByteDoubleMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableByteDoubleMap delegate;

    ImmutableByteDoubleHashMap(ByteDoubleMap delegate) {
        this.delegate = new ByteDoubleHashMap(delegate);
    }

    @Override
    public double get(byte key) {
        return this.delegate.get(key);
    }

    @Override
    public double getIfAbsent(byte key, double ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public double getOrThrow(byte key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public boolean containsKey(byte key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(double value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(DoubleProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(ByteProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(ByteDoubleProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public LazyByteIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<ByteDoublePair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableDoubleByteMap flipUniqueValues() {
        MutableDoubleByteMap result = DoubleByteMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result.toImmutable();
    }

    @Override
    public ImmutableByteDoubleMap select(ByteDoublePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableByteDoubleMap reject(ByteDoublePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public RichIterable<DoubleIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            DoubleIterator iterator = this.delegate.doubleIterator();
            while (iterator.hasNext()) {
                MutableDoubleBag batch = DoubleBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add(batch.toImmutable());
            }
        }
        return result.toImmutable();
    }

    @Override
    public ImmutableByteDoubleMap toImmutable() {
        return this;
    }

    @Override
    public DoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator(this.delegate.doubleIterator());
    }

    @Override
    public void each(DoubleProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(DoublePredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableDoubleBag select(DoublePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableDoubleBag reject(DoublePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(DoubleToObjectFunction<? extends V> function) {
        RichIterable bag = this.delegate.collect((DoubleToObjectFunction)function);
        return bag.toImmutable();
    }

    @Override
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public double sum() {
        return this.delegate.sum();
    }

    @Override
    public double max() {
        return this.delegate.max();
    }

    @Override
    public double maxIfEmpty(double defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public double min() {
        return this.delegate.min();
    }

    @Override
    public double minIfEmpty(double defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public double[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableDoubleList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public double[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public double[] toArray(double[] target) {
        return this.delegate.toArray(target);
    }

    @Override
    public boolean contains(double value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(double ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableDoubleList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableDoubleSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableDoubleBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyDoubleIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableByteDoubleMap newWithKeyValue(byte key, double value) {
        ByteDoubleHashMap map = new ByteDoubleHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    @Override
    public ImmutableByteDoubleMap newWithoutKey(byte key) {
        ByteDoubleHashMap map = new ByteDoubleHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    @Override
    public ImmutableByteDoubleMap newWithoutAllKeys(ByteIterable keys) {
        ByteDoubleHashMap map = new ByteDoubleHashMap(this.size());
        map.putAll(this);
        ByteIterator iterator = keys.byteIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(this.delegate.keySet());
    }

    @Override
    public MutableDoubleCollection values() {
        return UnmodifiableDoubleCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableByteDoubleMapSerializationProxy(this);
    }

    protected static class ImmutableByteDoubleMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ByteDoubleMap map;

        public ImmutableByteDoubleMapSerializationProxy() {
        }

        protected ImmutableByteDoubleMapSerializationProxy(ByteDoubleMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedByteDoubleProcedure(){

                    @Override
                    public void safeValue(byte key, double value) throws IOException {
                        out.writeByte(key);
                        out.writeDouble(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ByteDoubleHashMap deserializedMap = new ByteDoubleHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readByte(), in.readDouble());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

