/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.IntIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyIntIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.ShortIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.IntShortToShortFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.IntToShortFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ShortFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ShortFunction0;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ShortToShortFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.IntShortPredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.IntShortProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.IntShortMaps;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.ShortIntMaps;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.IntIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.MutableIntIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.MutableShortIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.ImmutableIntShortMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.IntShortMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.MutableIntShortMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.MutableShortIntMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.IntSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableIntSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.ShortSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.primitive.IntShortPair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.SpreadFunctions;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive.AbstractLazyIntIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableIntKeySet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableShortValuesMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.ImmutableIntMapKeySet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.MutableIntKeysMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.SynchronizedIntShortMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableIntShortMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntShortHashMap
extends AbstractMutableShortValuesMap
implements MutableIntShortMap,
Externalizable,
MutableIntKeysMap {
    private static final short EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_KEY = 0;
    private static final int REMOVED_KEY = 1;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 4;
    private static final int INITIAL_LINEAR_PROBE = 8;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private int[] keys;
    private short[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableShortValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public IntShortHashMap() {
        this.allocateTable(16);
    }

    public IntShortHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public IntShortHashMap(IntShortMap map) {
        if (map instanceof IntShortHashMap && ((IntShortHashMap)map).occupiedWithSentinels == 0) {
            IntShortHashMap hashMap = (IntShortHashMap)map;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keys = Arrays.copyOf(hashMap.keys, hashMap.keys.length);
            this.values = Arrays.copyOf(hashMap.values, hashMap.values.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map);
        }
    }

    public static IntShortHashMap newWithKeysValues(int key1, short value1) {
        return new IntShortHashMap(1).withKeyValue(key1, value1);
    }

    public static IntShortHashMap newWithKeysValues(int key1, short value1, int key2, short value2) {
        return new IntShortHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static IntShortHashMap newWithKeysValues(int key1, short value1, int key2, short value2, int key3, short value3) {
        return new IntShortHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static IntShortHashMap newWithKeysValues(int key1, short value1, int key2, short value2, int key3, short value3, int key4, short value4) {
        return new IntShortHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableShortValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected short getEmptyValue() {
        return 0;
    }

    @Override
    protected int getTableSize() {
        return this.values.length;
    }

    @Override
    protected short getValueAtIndex(int index) {
        return this.values[index];
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntShortMap)) {
            return false;
        }
        IntShortMap other = (IntShortMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0) || other.containsKey(1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0) || this.sentinelValues.zeroValue != other.getOrThrow(0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1) || this.sentinelValues.oneValue != other.getOrThrow(1))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            if (!IntShortHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntShortHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ this.values[i];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            if (!IntShortHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public MutableShortIterator shortIterator() {
        return new InternalShortIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectShortToObjectFunction<? super V, ? extends V> function) {
        V result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntShortHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, (short)0);
    }

    @Override
    public void put(int key, short value) {
        if (IntShortHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (IntShortHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        int keyAtIndex = this.keys[index];
        if (keyAtIndex == key) {
            this.values[index] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(short value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(short value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    @Override
    public void putAll(IntShortMap map) {
        map.forEachKeyValue(this::put);
    }

    @Override
    public void updateValues(IntShortToShortFunction function) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntShortHashMap.isNonSentinel(this.keys[i])) continue;
            this.values[i] = function.valueOf(this.keys[i], this.values[i]);
        }
    }

    @Override
    public void removeKey(int key) {
        if (IntShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (IntShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.removeKeyAtIndex(index);
        }
    }

    @Override
    public void remove(int key) {
        this.removeKey(key);
    }

    @Override
    public short removeKeyIfAbsent(int key, short value) {
        if (IntShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            short oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (IntShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            short oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            short oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    @Override
    public short getIfAbsentPut(int key, short value) {
        if (IntShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public short getAndPut(int key, short putValue, short defaultValue) {
        if (IntShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
            } else if (this.sentinelValues.containsZeroKey) {
                short existingValue = this.sentinelValues.zeroValue;
                this.sentinelValues.zeroValue = putValue;
                return existingValue;
            }
            this.addEmptyKeyValue(putValue);
            return defaultValue;
        }
        if (IntShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
            } else if (this.sentinelValues.containsOneKey) {
                short existingValue = this.sentinelValues.oneValue;
                this.sentinelValues.oneValue = putValue;
                return existingValue;
            }
            this.addRemovedKeyValue(putValue);
            return defaultValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            short existingValue = this.values[index];
            this.values[index] = putValue;
            return existingValue;
        }
        this.addKeyValueAtIndex(key, putValue, index);
        return defaultValue;
    }

    @Override
    public short getIfAbsentPut(int key, ShortFunction0 function) {
        if (IntShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.value();
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.value();
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        short value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> short getIfAbsentPutWith(int key, ShortFunction<? super P> function, P parameter) {
        if (IntShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.shortValueOf(parameter);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.shortValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.shortValueOf(parameter);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.shortValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        short value = function.shortValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public short getIfAbsentPutWithKey(int key, IntToShortFunction function) {
        if (IntShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        short value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public short addToValue(int key, short toBeAdded) {
        if (IntShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = (short)(this.sentinelValues.zeroValue + toBeAdded);
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = (short)(this.sentinelValues.oneValue + toBeAdded);
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = (short)(this.values[n] + toBeAdded);
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    private void addKeyValueAtIndex(int key, short value, int index) {
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = 1;
        this.values[index] = 0;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        int[] copy = new int[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    @Override
    public short updateValue(int key, short initialValueIfAbsent, ShortToShortFunction function) {
        if (IntShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        short value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public IntShortHashMap withKeyValue(int key1, short value1) {
        this.put(key1, value1);
        return this;
    }

    public IntShortHashMap withKeysValues(int key1, short value1, int key2, short value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public IntShortHashMap withKeysValues(int key1, short value1, int key2, short value2, int key3, short value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public IntShortHashMap withKeysValues(int key1, short value1, int key2, short value2, int key3, short value3, int key4, short value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    @Override
    public IntShortHashMap withoutKey(int key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public IntShortHashMap withoutAllKeys(IntIterable keys) {
        keys.forEach(this::removeKey);
        return this;
    }

    @Override
    public MutableIntShortMap asUnmodifiable() {
        return new UnmodifiableIntShortMap(this);
    }

    @Override
    public MutableIntShortMap asSynchronized() {
        return new SynchronizedIntShortMap(this);
    }

    @Override
    public ImmutableIntShortMap toImmutable() {
        return IntShortMaps.immutable.ofAll(this);
    }

    @Override
    public short get(int key) {
        return this.getIfAbsent(key, (short)0);
    }

    @Override
    public short getIfAbsent(int key, short ifAbsent) {
        if (IntShortHashMap.isEmptyKey(key) || IntShortHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        if (this.occupiedWithSentinels == 0) {
            return this.fastGetIfAbsent(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private short getForSentinel(int key, short ifAbsent) {
        if (IntShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private short slowGetIfAbsent(int key, short ifAbsent) {
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    private short fastGetIfAbsent(int key, short ifAbsent) {
        int index = this.mask(key);
        for (int i = 0; i < 8; ++i) {
            int keyAtIndex = this.keys[index];
            if (keyAtIndex == key) {
                return this.values[index];
            }
            if (keyAtIndex == 0) {
                return ifAbsent;
            }
            index = index + 1 & this.keys.length - 1;
        }
        return this.slowGetIfAbsentTwo(key, ifAbsent);
    }

    private short slowGetIfAbsentTwo(int key, short ifAbsent) {
        int index = this.probeTwo(key, -1);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    @Override
    public short getOrThrow(int key) {
        if (IntShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (IntShortHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(int key) {
        if (IntShortHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (IntShortHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    @Override
    public void forEachKey(IntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntShortHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    @Override
    public void forEachKeyValue(IntShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntShortHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    @Override
    public LazyIntIterable keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<IntShortPair> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public MutableShortIntMap flipUniqueValues() {
        MutableShortIntMap result = ShortIntMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result;
    }

    @Override
    public IntShortHashMap select(IntShortPredicate predicate) {
        IntShortHashMap result = new IntShortHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0, this.sentinelValues.zeroValue)) {
                result.put(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1, this.sentinelValues.oneValue)) {
                result.put(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public IntShortHashMap reject(IntShortPredicate predicate) {
        IntShortHashMap result = new IntShortHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0, this.sentinelValues.zeroValue)) {
                result.put(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1, this.sentinelValues.oneValue)) {
                result.put(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntShortHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeInt(0);
                out.writeShort(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeInt(1);
                out.writeShort(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntShortHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeInt(this.keys[i]);
            out.writeShort(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readInt(), in.readShort());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        int[] old = this.keys;
        short[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!IntShortHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(int element) {
        int index = this.mask(element);
        int keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        for (int i = 1; i < 8; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(int element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 8; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            int keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(int element, int removedIndex) {
        int nextIndex = SpreadFunctions.intSpreadOne(element);
        int spreadTwo = Integer.reverse(SpreadFunctions.intSpreadTwo(element)) | 1;
        int keyAtIndex;
        while ((keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(int element) {
        int code = SpreadFunctions.intSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(int element) {
        int code = SpreadFunctions.intSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new int[sizeToAllocate];
        this.values = new short[sizeToAllocate];
    }

    private static boolean isEmptyKey(int key) {
        return key == 0;
    }

    private static boolean isRemovedKey(int key) {
        return key == 1;
    }

    private static boolean isNonSentinel(int key) {
        return !IntShortHashMap.isEmptyKey(key) && !IntShortHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !IntShortHashMap.isEmptyKey(this.keys[index]) && !IntShortHashMap.isRemovedKey(this.keys[index]);
    }

    private int maxOccupiedWithData() {
        return this.keys.length >> 1;
    }

    @Override
    public MutableIntSet keySet() {
        return new KeySet();
    }

    @Override
    public MutableShortCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ int[] access$302(IntShortHashMap x0, int[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ short[] access$502(IntShortHashMap x0, short[] x1) {
        x0.values = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<IntShortPair> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super IntShortPair> procedure) {
            if (IntShortHashMap.this.sentinelValues != null) {
                if (((IntShortHashMap)IntShortHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair(0, ((IntShortHashMap)IntShortHashMap.this).sentinelValues.zeroValue));
                }
                if (((IntShortHashMap)IntShortHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair(1, ((IntShortHashMap)IntShortHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < IntShortHashMap.this.keys.length; ++i) {
                if (!IntShortHashMap.isNonSentinel(IntShortHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(IntShortHashMap.this.keys[i], IntShortHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super IntShortPair> objectIntProcedure) {
            int index = 0;
            if (IntShortHashMap.this.sentinelValues != null) {
                if (((IntShortHashMap)IntShortHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair(0, ((IntShortHashMap)IntShortHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((IntShortHashMap)IntShortHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair(1, ((IntShortHashMap)IntShortHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < IntShortHashMap.this.keys.length; ++i) {
                if (!IntShortHashMap.isNonSentinel(IntShortHashMap.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(IntShortHashMap.this.keys[i], IntShortHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super IntShortPair, ? super P> procedure, P parameter) {
            if (IntShortHashMap.this.sentinelValues != null) {
                if (((IntShortHashMap)IntShortHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair(0, ((IntShortHashMap)IntShortHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((IntShortHashMap)IntShortHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair(1, ((IntShortHashMap)IntShortHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < IntShortHashMap.this.keys.length; ++i) {
                if (!IntShortHashMap.isNonSentinel(IntShortHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(IntShortHashMap.this.keys[i], IntShortHashMap.this.values[i]), parameter);
            }
        }

        @Override
        public Iterator<IntShortPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<IntShortPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public IntShortPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (IntShortHashMap.this.containsKey(0)) {
                        return PrimitiveTuples.pair(0, ((IntShortHashMap)IntShortHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (IntShortHashMap.this.containsKey(1)) {
                        return PrimitiveTuples.pair(1, ((IntShortHashMap)IntShortHashMap.this).sentinelValues.oneValue);
                    }
                }
                int[] keys = IntShortHashMap.this.keys;
                while (!IntShortHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                IntShortPair result = PrimitiveTuples.pair(keys[this.position], IntShortHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != IntShortHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableShortValuesMap.AbstractShortValuesCollection {
        private ValuesCollection() {
        }

        @Override
        public MutableShortIterator shortIterator() {
            return IntShortHashMap.this.shortIterator();
        }

        @Override
        public boolean remove(short item) {
            int oldSize = IntShortHashMap.this.size();
            if (IntShortHashMap.this.sentinelValues != null && ((IntShortHashMap)IntShortHashMap.this).sentinelValues.containsZeroKey && item == ((IntShortHashMap)IntShortHashMap.this).sentinelValues.zeroValue) {
                IntShortHashMap.this.removeKey(0);
            }
            if (IntShortHashMap.this.sentinelValues != null && ((IntShortHashMap)IntShortHashMap.this).sentinelValues.containsOneKey && item == ((IntShortHashMap)IntShortHashMap.this).sentinelValues.oneValue) {
                IntShortHashMap.this.removeKey(1);
            }
            for (int i = 0; i < IntShortHashMap.this.keys.length; ++i) {
                if (!IntShortHashMap.isNonSentinel(IntShortHashMap.this.keys[i]) || item != IntShortHashMap.this.values[i]) continue;
                IntShortHashMap.this.removeKey(IntShortHashMap.this.keys[i]);
            }
            return oldSize != IntShortHashMap.this.size();
        }

        @Override
        public boolean retainAll(ShortIterable source) {
            int oldSize = IntShortHashMap.this.size();
            ShortSet sourceSet = source instanceof ShortSet ? (ShortSet)source : source.toSet();
            IntShortHashMap retained = IntShortHashMap.this.select((int key, short value) -> sourceSet.contains(value));
            if (retained.size() != oldSize) {
                IntShortHashMap.access$302(IntShortHashMap.this, retained.keys);
                IntShortHashMap.access$502(IntShortHashMap.this, retained.values);
                IntShortHashMap.this.sentinelValues = retained.sentinelValues;
                IntShortHashMap.this.occupiedWithData = retained.occupiedWithData;
                IntShortHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public MutableShortCollection newEmpty() {
            return new ShortHashBag();
        }
    }

    private class KeySet
    extends AbstractMutableIntKeySet {
        private KeySet() {
        }

        @Override
        protected MutableIntKeysMap getOuter() {
            return IntShortHashMap.this;
        }

        @Override
        protected AbstractMutableShortValuesMap.SentinelValues getSentinelValues() {
            return IntShortHashMap.this.sentinelValues;
        }

        @Override
        protected int getKeyAtIndex(int index) {
            return IntShortHashMap.this.keys[index];
        }

        @Override
        protected int getTableSize() {
            return IntShortHashMap.this.keys.length;
        }

        @Override
        public MutableIntIterator intIterator() {
            return new KeySetIterator();
        }

        @Override
        public boolean retainAll(IntIterable source) {
            int oldSize = IntShortHashMap.this.size();
            IntSet sourceSet = source instanceof IntSet ? (IntSet)source : source.toSet();
            IntShortHashMap retained = IntShortHashMap.this.select((int key, short value) -> sourceSet.contains(key));
            if (retained.size() != oldSize) {
                IntShortHashMap.access$302(IntShortHashMap.this, retained.keys);
                IntShortHashMap.access$502(IntShortHashMap.this, retained.values);
                IntShortHashMap.this.sentinelValues = retained.sentinelValues;
                IntShortHashMap.this.occupiedWithData = retained.occupiedWithData;
                IntShortHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(int ... source) {
            return this.retainAll(IntHashSet.newSetWith(source));
        }

        @Override
        public IntSet freeze() {
            IntShortHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (IntShortHashMap.this.sentinelValues != null) {
                containsZeroKey = ((IntShortHashMap)IntShortHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((IntShortHashMap)IntShortHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableIntMapKeySet(IntShortHashMap.this.keys, IntShortHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }

        @Override
        public MutableIntSet newEmpty() {
            return new IntHashSet();
        }
    }

    private class KeySetIterator
    implements MutableIntIterator {
        private int count;
        private int position;
        private int lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < IntShortHashMap.this.size();
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntShortHashMap.this.containsKey(0)) {
                    this.lastKey = 0;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntShortHashMap.this.containsKey(1)) {
                    this.lastKey = 1;
                    return this.lastKey;
                }
            }
            int[] keys = IntShortHashMap.this.keys;
            while (!IntShortHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            IntShortHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyIntIterable {
        private KeysView() {
        }

        @Override
        public IntIterator intIterator() {
            return new UnmodifiableIntIterator(new KeySetIterator());
        }

        @Override
        public void each(IntProcedure procedure) {
            IntShortHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalShortIterator
    implements MutableShortIterator {
        private int count;
        private int position;
        private int lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalShortIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < IntShortHashMap.this.size();
        }

        @Override
        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntShortHashMap.this.containsKey(0)) {
                    this.lastKey = 0;
                    return IntShortHashMap.this.get(0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntShortHashMap.this.containsKey(1)) {
                    this.lastKey = 1;
                    return IntShortHashMap.this.get(1);
                }
            }
            int[] keys = IntShortHashMap.this.keys;
            while (!IntShortHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            short result = IntShortHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            IntShortHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

