/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.IntIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyIntIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.MutableIntBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.HashingStrategy;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.IntFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.IntFunction0;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.IntToIntFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ObjectIntToIntFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.ObjectIntPredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.MutableCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.IntBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.IntLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.IntObjectMaps;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.IntSets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.ObjectIntMaps;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.IntIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.MutableIntIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.MutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.MutableIntList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.ImmutableObjectIntMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.ObjectIntMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.IntSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableIntSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.primitive.ObjectIntPair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedIntCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.SynchronizedObjectIntMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableObjectIntMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ObjectIntHashMapWithHashingStrategy<K>
implements MutableObjectIntMap<K>,
Externalizable {
    public static final int EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final Object NULL_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectIntHashMapWithHashingStrategy.NULL_KEY";
        }
    };
    private static final Object REMOVED_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectIntHashMapWithHashingStrategy.REMOVED_KEY";
        }
    };
    private Object[] keys;
    private int[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private HashingStrategy<? super K> hashingStrategy;

    @Deprecated
    public ObjectIntHashMapWithHashingStrategy() {
    }

    public ObjectIntHashMapWithHashingStrategy(HashingStrategy<? super K> hashingStrategy) {
        this.hashingStrategy = hashingStrategy;
        this.allocateTable(16);
    }

    public ObjectIntHashMapWithHashingStrategy(HashingStrategy<? super K> hashingStrategy, int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        this.hashingStrategy = hashingStrategy;
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity << 1));
        this.allocateTable(capacity);
    }

    public ObjectIntHashMapWithHashingStrategy(HashingStrategy<? super K> hashingStrategy, ObjectIntMap<? extends K> map) {
        this(hashingStrategy, Math.max(map.size(), 8));
        this.putAll(map);
    }

    public static <K> ObjectIntHashMapWithHashingStrategy<K> newMap(HashingStrategy<? super K> hashingStrategy) {
        return new ObjectIntHashMapWithHashingStrategy<K>(hashingStrategy);
    }

    public static <K> ObjectIntHashMapWithHashingStrategy<K> newMap(HashingStrategy<? super K> hashingStrategy, ObjectIntMap<K> map) {
        return new ObjectIntHashMapWithHashingStrategy<K>(hashingStrategy, map);
    }

    public static <K> ObjectIntHashMapWithHashingStrategy<K> newMap(ObjectIntHashMapWithHashingStrategy<K> map) {
        return new ObjectIntHashMapWithHashingStrategy<K>(map.hashingStrategy, map);
    }

    public static <K> ObjectIntHashMapWithHashingStrategy<K> newMapWithInitialCapacity(HashingStrategy<? super K> hashingStrategy, int initialCapacity) {
        return new ObjectIntHashMapWithHashingStrategy<K>(hashingStrategy, initialCapacity);
    }

    public static <K> ObjectIntHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, int value1) {
        return new ObjectIntHashMapWithHashingStrategy<K>(hashingStrategy, 1).withKeyValue((Object)key1, value1);
    }

    public static <K> ObjectIntHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, int value1, K key2, int value2) {
        return new ObjectIntHashMapWithHashingStrategy<K>(hashingStrategy, 2).withKeysValues(key1, value1, key2, value2);
    }

    public static <K> ObjectIntHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, int value1, K key2, int value2, K key3, int value3) {
        return new ObjectIntHashMapWithHashingStrategy<K>(hashingStrategy, 3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static <K> ObjectIntHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, int value1, K key2, int value2, K key3, int value3, K key4, int value4) {
        return new ObjectIntHashMapWithHashingStrategy<K>(hashingStrategy, 4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectIntMap)) {
            return false;
        }
        ObjectIntMap other = (ObjectIntMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || other.containsKey(this.toNonSentinel(this.keys[i])) && this.values[i] == other.getOrThrow(this.toNonSentinel(this.keys[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result += this.hashingStrategy.computeHashCode(this.toNonSentinel(this.keys[i])) ^ this.values[i];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        for (int i = 0; i < this.keys.length; ++i) {
            Object key = this.keys[i];
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(this.toNonSentinel(key)).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public int size() {
        return this.occupiedWithData;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean notEmpty() {
        return this.size() != 0;
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            for (int i = 0; i < this.keys.length; ++i) {
                Object key = this.keys[i];
                if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(String.valueOf(this.values[i])));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MutableIntIterator intIterator() {
        return new InternalIntIterator();
    }

    @Override
    public int[] toArray() {
        int[] result = new int[this.size()];
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result[index] = this.values[i];
            ++index;
        }
        return result;
    }

    @Override
    public int[] toArray(int[] target) {
        if (target.length < this.size()) {
            target = new int[this.size()];
        }
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            target[index] = this.values[i];
            ++index;
        }
        return target;
    }

    @Override
    public boolean contains(int value) {
        return this.containsValue(value);
    }

    @Override
    public boolean containsAll(int ... source) {
        for (int item : source) {
            if (this.containsValue(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(IntIterable source) {
        return this.containsAll(source.toArray());
    }

    @Override
    public void clear() {
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, 0);
    }

    @Override
    public void put(K key, int value) {
        int index = this.probe(key);
        if (ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    @Override
    public void putAll(ObjectIntMap<? extends K> map) {
        map.forEachKeyValue(this::put);
    }

    @Override
    public void updateValues(ObjectIntToIntFunction<? super K> function) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            this.values[i] = function.valueOf(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    @Override
    public void removeKey(K key) {
        int index = this.probe(key);
        this.removeKeyAtIndex(key, index);
    }

    public void removeKeyAtIndex(K key, int index) {
        if (ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
        }
    }

    @Override
    public void remove(Object key) {
        this.removeKey(key);
    }

    @Override
    public int removeKeyIfAbsent(K key, int value) {
        int index = this.probe(key);
        if (ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            int oldValue = this.values[index];
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            return oldValue;
        }
        return value;
    }

    @Override
    public int getIfAbsentPut(K key, int value) {
        int index = this.probe(key);
        if (ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public int getAndPut(K key, int putValue, int defaultValue) {
        int index = this.probe(key);
        if (ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            int existingValue = this.values[index];
            this.values[index] = putValue;
            return existingValue;
        }
        this.addKeyValueAtIndex(key, putValue, index);
        return defaultValue;
    }

    @Override
    public int getIfAbsentPut(K key, IntFunction0 function) {
        int index = this.probe(key);
        if (ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        int value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> int getIfAbsentPutWith(K key, IntFunction<? super P> function, P parameter) {
        int index = this.probe(key);
        if (ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        int value = function.intValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public int getIfAbsentPutWithKey(K key, IntFunction<? super K> function) {
        int index = this.probe(key);
        if (ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        int value = function.intValueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public int updateValue(K key, int initialValueIfAbsent, IntToIntFunction function) {
        int index = this.probe(key);
        if (ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        int value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    private void addKeyValueAtIndex(K key, int value, int index) {
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectIntHashMapWithHashingStrategy.toSentinelIfNull(key);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    @Override
    public int addToValue(K key, int toBeAdded) {
        int index = this.probe(key);
        if (ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    @Override
    public ObjectIntHashMapWithHashingStrategy<K> withKeyValue(K key1, int value1) {
        this.put(key1, value1);
        return this;
    }

    public ObjectIntHashMapWithHashingStrategy<K> withKeysValues(K key1, int value1, K key2, int value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ObjectIntHashMapWithHashingStrategy<K> withKeysValues(K key1, int value1, K key2, int value2, K key3, int value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ObjectIntHashMapWithHashingStrategy<K> withKeysValues(K key1, int value1, K key2, int value2, K key3, int value3, K key4, int value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    @Override
    public ObjectIntHashMapWithHashingStrategy<K> withoutKey(K key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public ObjectIntHashMapWithHashingStrategy<K> withoutAllKeys(Iterable<? extends K> keys) {
        for (K key : keys) {
            this.removeKey(key);
        }
        return this;
    }

    @Override
    public MutableObjectIntMap<K> asUnmodifiable() {
        return new UnmodifiableObjectIntMap(this);
    }

    @Override
    public MutableObjectIntMap<K> asSynchronized() {
        return new SynchronizedObjectIntMap(this);
    }

    @Override
    public ImmutableObjectIntMap<K> toImmutable() {
        return ObjectIntMaps.immutable.withAll(this);
    }

    @Override
    public int get(Object key) {
        return this.getIfAbsent(key, 0);
    }

    @Override
    public int getOrThrow(Object key) {
        int index = this.probe(key);
        if (ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public int getIfAbsent(Object key, int ifAbsent) {
        int index = this.probe(key);
        if (ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        return ifAbsent;
    }

    @Override
    public boolean containsKey(Object key) {
        int index = this.probe(key);
        return ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key);
    }

    @Override
    public boolean containsValue(int value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public void each(IntProcedure procedure) {
        this.forEachValue(procedure);
    }

    @Override
    public void forEachValue(IntProcedure procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]));
        }
    }

    @Override
    public void forEachKeyValue(ObjectIntProcedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    @Override
    public ObjectIntHashMapWithHashingStrategy<K> select(ObjectIntPredicate<? super K> predicate) {
        ObjectIntHashMapWithHashingStrategy<K> result = ObjectIntHashMapWithHashingStrategy.newMap(this.hashingStrategy);
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    @Override
    public ObjectIntHashMapWithHashingStrategy<K> reject(ObjectIntPredicate<? super K> predicate) {
        ObjectIntHashMapWithHashingStrategy<K> result = ObjectIntHashMapWithHashingStrategy.newMap(this.hashingStrategy);
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    @Override
    public MutableIntCollection select(IntPredicate predicate) {
        MutableIntList result = IntLists.mutable.empty();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public MutableIntCollection reject(IntPredicate predicate) {
        MutableIntList result = IntLists.mutable.empty();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return ifNone;
    }

    @Override
    public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        MutableList result = Lists.mutable.withInitialCapacity(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(function.valueOf(this.values[i]));
        }
        return result;
    }

    @Override
    public int count(IntPredicate predicate) {
        int count = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectIntToObjectFunction<? super V, ? extends V> function) {
        V result = injectedValue;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public RichIterable<IntIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList<IntIterable> result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableIntIterator iterator = this.intIterator();
            while (iterator.hasNext()) {
                MutableIntBag batch = IntBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add(batch);
            }
        }
        return result;
    }

    @Override
    public long sum() {
        long result = 0L;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    @Override
    public int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int max = 0;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMaxSet && max >= this.values[i]) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    @Override
    public int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int min2 = 0;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMinSet && this.values[i] >= min2) continue;
            min2 = this.values[i];
            isMinSet = true;
        }
        return min2;
    }

    @Override
    public int maxIfEmpty(int defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        int max = 0;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMaxSet && max >= this.values[i]) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    @Override
    public int minIfEmpty(int defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        int min2 = 0;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMinSet && this.values[i] >= min2) continue;
            min2 = this.values[i];
            isMinSet = true;
        }
        return min2;
    }

    @Override
    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        int[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            int first = sortedArray[middleIndex];
            int second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public MutableIntList toList() {
        MutableIntList result = IntLists.mutable.withInitialCapacity(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public MutableIntSet toSet() {
        MutableIntSet result = IntSets.mutable.empty();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public MutableIntBag toBag() {
        MutableIntBag result = IntBags.mutable.empty();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter(this);
    }

    @Override
    public int[] toSortedArray() {
        int[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableIntList toSortedList() {
        return this.toList().sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.hashingStrategy);
        out.writeInt(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            out.writeObject(this.toNonSentinel(this.keys[i]));
            out.writeInt(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.hashingStrategy = (HashingStrategy)in.readObject();
        int size = in.readInt();
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(size << 1));
        this.allocateTable(capacity);
        for (int i = 0; i < size; ++i) {
            this.put(in.readObject(), in.readInt());
        }
    }

    @Override
    public LazyIterable<K> keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<ObjectIntPair<K>> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public MutableIntObjectMap<K> flipUniqueValues() {
        MutableIntObjectMap result = IntObjectMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            Object oldKey = result.put(value, key);
            if (oldKey != null) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + oldKey + " and key: " + key);
            }
        });
        return result;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        Object[] old = this.keys;
        int[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(old[i])) continue;
            this.put(this.toNonSentinel(old[i]), oldValues[i]);
        }
    }

    int probe(Object element) {
        int index = this.spread(element);
        int removedIndex = -1;
        if (ObjectIntHashMapWithHashingStrategy.isRemovedKey(this.keys[index])) {
            removedIndex = index;
        } else if (this.keys[index] == null || this.nullSafeEquals(this.toNonSentinel(this.keys[index]), element)) {
            return index;
        }
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (ObjectIntHashMapWithHashingStrategy.isRemovedKey(this.keys[nextIndex &= this.keys.length - 1])) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.nullSafeEquals(this.toNonSentinel(this.keys[nextIndex]), element)) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == null) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(Object element) {
        K nonSentinelKey = this.toNonSentinel(element);
        int h2 = nonSentinelKey == null ? 0 : this.hashingStrategy.computeHashCode(nonSentinelKey);
        h2 ^= h2 >>> 20 ^ h2 >>> 12;
        h2 ^= h2 >>> 7 ^ h2 >>> 4;
        return h2 & this.keys.length - 1;
    }

    private boolean nullSafeEquals(K value, Object other) {
        return value == null ? other == null : value != NULL_KEY && other != null && this.hashingStrategy.equals(value, this.toNonSentinel(other));
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new Object[sizeToAllocate];
        this.values = new int[sizeToAllocate];
    }

    private static boolean isRemovedKey(Object key) {
        return key == REMOVED_KEY;
    }

    private static <K> boolean isNonSentinel(K key) {
        return key != null && !ObjectIntHashMapWithHashingStrategy.isRemovedKey(key);
    }

    private K toNonSentinel(Object key) {
        return (K)(key == NULL_KEY ? null : key);
    }

    private static Object toSentinelIfNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity >> 1);
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public MutableIntCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ Object[] access$302(ObjectIntHashMapWithHashingStrategy x0, Object[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ int[] access$502(ObjectIntHashMapWithHashingStrategy x0, int[] x1) {
        x0.values = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<ObjectIntPair<K>> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super ObjectIntPair<K>> procedure) {
            for (int i = 0; i < ObjectIntHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(ObjectIntHashMapWithHashingStrategy.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectIntHashMapWithHashingStrategy.this.toNonSentinel(ObjectIntHashMapWithHashingStrategy.this.keys[i]), ObjectIntHashMapWithHashingStrategy.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ObjectIntPair<K>> objectIntProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectIntHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(ObjectIntHashMapWithHashingStrategy.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(ObjectIntHashMapWithHashingStrategy.this.toNonSentinel(ObjectIntHashMapWithHashingStrategy.this.keys[i]), ObjectIntHashMapWithHashingStrategy.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ObjectIntPair<K>, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectIntHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(ObjectIntHashMapWithHashingStrategy.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectIntHashMapWithHashingStrategy.this.toNonSentinel(ObjectIntHashMapWithHashingStrategy.this.keys[i]), ObjectIntHashMapWithHashingStrategy.this.values[i]), parameter);
            }
        }

        @Override
        public Iterator<ObjectIntPair<K>> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<ObjectIntPair<K>> {
            private int count;
            private int position;

            @Override
            public ObjectIntPair<K> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectIntHashMapWithHashingStrategy.this.keys;
                while (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ObjectIntPair<Object> result = PrimitiveTuples.pair(ObjectIntHashMapWithHashingStrategy.this.toNonSentinel(ObjectIntHashMapWithHashingStrategy.this.keys[this.position]), ObjectIntHashMapWithHashingStrategy.this.values[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectIntHashMapWithHashingStrategy.this.size();
            }
        }
    }

    private class KeysView
    extends AbstractLazyIterable<K> {
        private KeysView() {
        }

        @Override
        public void each(Procedure<? super K> procedure) {
            ObjectIntHashMapWithHashingStrategy.this.forEachKey(procedure);
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super K> objectIntProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectIntHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(ObjectIntHashMapWithHashingStrategy.this.keys[i])) continue;
                objectIntProcedure.value(ObjectIntHashMapWithHashingStrategy.this.toNonSentinel(ObjectIntHashMapWithHashingStrategy.this.keys[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super K, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectIntHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(ObjectIntHashMapWithHashingStrategy.this.keys[i])) continue;
                procedure.value(ObjectIntHashMapWithHashingStrategy.this.toNonSentinel(ObjectIntHashMapWithHashingStrategy.this.keys[i]), parameter);
            }
        }

        @Override
        public Iterator<K> iterator() {
            return new InternalKeysViewIterator();
        }

        public class InternalKeysViewIterator
        implements Iterator<K> {
            private int count;
            private int position;

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectIntHashMapWithHashingStrategy.this.keys;
                while (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                Object result = ObjectIntHashMapWithHashingStrategy.this.toNonSentinel(ObjectIntHashMapWithHashingStrategy.this.keys[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectIntHashMapWithHashingStrategy.this.size();
            }
        }
    }

    private class ValuesCollection
    implements MutableIntCollection {
        private ValuesCollection() {
        }

        @Override
        public int size() {
            return ObjectIntHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectIntHashMapWithHashingStrategy.this.isEmpty();
        }

        @Override
        public boolean notEmpty() {
            return ObjectIntHashMapWithHashingStrategy.this.notEmpty();
        }

        @Override
        public String makeString() {
            return this.makeString(", ");
        }

        @Override
        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        @Override
        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        @Override
        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        @Override
        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        @Override
        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                for (int i = 0; i < ObjectIntHashMapWithHashingStrategy.this.keys.length; ++i) {
                    Object key = ObjectIntHashMapWithHashingStrategy.this.keys[i];
                    if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ObjectIntHashMapWithHashingStrategy.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean add(int element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(int ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(IntIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(int item) {
            int oldSize = ObjectIntHashMapWithHashingStrategy.this.size();
            for (int i = 0; i < ObjectIntHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(ObjectIntHashMapWithHashingStrategy.this.keys[i]) || item != ObjectIntHashMapWithHashingStrategy.this.values[i]) continue;
                ObjectIntHashMapWithHashingStrategy.this.removeKey(ObjectIntHashMapWithHashingStrategy.this.keys[i]);
            }
            return oldSize != ObjectIntHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean removeAll(IntIterable source) {
            int oldSize = ObjectIntHashMapWithHashingStrategy.this.size();
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != ObjectIntHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean removeAll(int ... source) {
            int oldSize = ObjectIntHashMapWithHashingStrategy.this.size();
            for (int item : source) {
                this.remove(item);
            }
            return oldSize != ObjectIntHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean retainAll(IntIterable source) {
            int oldSize = ObjectIntHashMapWithHashingStrategy.this.size();
            IntSet sourceSet = source instanceof IntSet ? (IntSet)source : source.toSet();
            MutableObjectIntMap retained = ObjectIntHashMapWithHashingStrategy.this.select((T object, int value) -> sourceSet.contains(value));
            if (((ObjectIntHashMapWithHashingStrategy)retained).size() != oldSize) {
                ObjectIntHashMapWithHashingStrategy.access$302(ObjectIntHashMapWithHashingStrategy.this, ((ObjectIntHashMapWithHashingStrategy)retained).keys);
                ObjectIntHashMapWithHashingStrategy.access$502(ObjectIntHashMapWithHashingStrategy.this, ((ObjectIntHashMapWithHashingStrategy)retained).values);
                ObjectIntHashMapWithHashingStrategy.this.occupiedWithData = ((ObjectIntHashMapWithHashingStrategy)retained).occupiedWithData;
                ObjectIntHashMapWithHashingStrategy.this.occupiedWithSentinels = ((ObjectIntHashMapWithHashingStrategy)retained).occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(int ... source) {
            return this.retainAll(IntSets.mutable.with(source));
        }

        @Override
        public void clear() {
            ObjectIntHashMapWithHashingStrategy.this.clear();
        }

        @Override
        public MutableIntCollection with(int element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableIntCollection without(int element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableIntCollection withAll(IntIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableIntCollection withoutAll(IntIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableIntCollection asUnmodifiable() {
            return UnmodifiableIntCollection.of(this);
        }

        @Override
        public MutableIntCollection asSynchronized() {
            return SynchronizedIntCollection.of(this);
        }

        @Override
        public ImmutableIntCollection toImmutable() {
            return IntLists.immutable.withAll(this);
        }

        @Override
        public MutableIntIterator intIterator() {
            return ObjectIntHashMapWithHashingStrategy.this.intIterator();
        }

        @Override
        public int[] toArray() {
            return ObjectIntHashMapWithHashingStrategy.this.toArray();
        }

        @Override
        public int[] toArray(int[] target) {
            return ObjectIntHashMapWithHashingStrategy.this.toArray(target);
        }

        @Override
        public boolean contains(int value) {
            return ObjectIntHashMapWithHashingStrategy.this.containsValue(value);
        }

        @Override
        public boolean containsAll(int ... source) {
            return ObjectIntHashMapWithHashingStrategy.this.containsAll(source);
        }

        @Override
        public boolean containsAll(IntIterable source) {
            return ObjectIntHashMapWithHashingStrategy.this.containsAll(source);
        }

        @Override
        public void forEach(IntProcedure procedure) {
            ObjectIntHashMapWithHashingStrategy.this.forEach(procedure);
        }

        @Override
        public void each(IntProcedure procedure) {
            this.forEach(procedure);
        }

        @Override
        public MutableIntCollection select(IntPredicate predicate) {
            return ObjectIntHashMapWithHashingStrategy.this.select(predicate);
        }

        @Override
        public MutableIntCollection reject(IntPredicate predicate) {
            return ObjectIntHashMapWithHashingStrategy.this.reject(predicate);
        }

        @Override
        public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
            return ObjectIntHashMapWithHashingStrategy.this.collect((IntToObjectFunction)function);
        }

        @Override
        public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
            return ObjectIntHashMapWithHashingStrategy.this.injectInto(injectedValue, function);
        }

        @Override
        public RichIterable<IntIterable> chunk(int size) {
            return ObjectIntHashMapWithHashingStrategy.this.chunk(size);
        }

        @Override
        public int detectIfNone(IntPredicate predicate, int ifNone) {
            return ObjectIntHashMapWithHashingStrategy.this.detectIfNone(predicate, ifNone);
        }

        @Override
        public int count(IntPredicate predicate) {
            return ObjectIntHashMapWithHashingStrategy.this.count(predicate);
        }

        @Override
        public boolean anySatisfy(IntPredicate predicate) {
            return ObjectIntHashMapWithHashingStrategy.this.anySatisfy(predicate);
        }

        @Override
        public boolean allSatisfy(IntPredicate predicate) {
            return ObjectIntHashMapWithHashingStrategy.this.allSatisfy(predicate);
        }

        @Override
        public boolean noneSatisfy(IntPredicate predicate) {
            return ObjectIntHashMapWithHashingStrategy.this.noneSatisfy(predicate);
        }

        @Override
        public MutableIntList toList() {
            return ObjectIntHashMapWithHashingStrategy.this.toList();
        }

        @Override
        public MutableIntSet toSet() {
            return ObjectIntHashMapWithHashingStrategy.this.toSet();
        }

        @Override
        public MutableIntBag toBag() {
            return ObjectIntHashMapWithHashingStrategy.this.toBag();
        }

        @Override
        public LazyIntIterable asLazy() {
            return new LazyIntIterableAdapter(this);
        }

        @Override
        public int[] toSortedArray() {
            return ObjectIntHashMapWithHashingStrategy.this.toSortedArray();
        }

        @Override
        public MutableIntList toSortedList() {
            return ObjectIntHashMapWithHashingStrategy.this.toSortedList();
        }

        @Override
        public long sum() {
            return ObjectIntHashMapWithHashingStrategy.this.sum();
        }

        @Override
        public int max() {
            return ObjectIntHashMapWithHashingStrategy.this.max();
        }

        @Override
        public int maxIfEmpty(int defaultValue) {
            return ObjectIntHashMapWithHashingStrategy.this.maxIfEmpty(defaultValue);
        }

        @Override
        public int min() {
            return ObjectIntHashMapWithHashingStrategy.this.min();
        }

        @Override
        public int minIfEmpty(int defaultValue) {
            return ObjectIntHashMapWithHashingStrategy.this.minIfEmpty(defaultValue);
        }

        @Override
        public double average() {
            return ObjectIntHashMapWithHashingStrategy.this.average();
        }

        @Override
        public double median() {
            return ObjectIntHashMapWithHashingStrategy.this.median();
        }

        @Override
        public MutableIntCollection newEmpty() {
            return IntBags.mutable.empty();
        }
    }

    private class KeySetIterator
    implements Iterator<K> {
        private int count;
        private int position;
        private K currentKey;
        private boolean isCurrentKeySet;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ObjectIntHashMapWithHashingStrategy.this.size();
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            Object[] keys = ObjectIntHashMapWithHashingStrategy.this.keys;
            while (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.currentKey = ObjectIntHashMapWithHashingStrategy.this.keys[this.position];
            this.isCurrentKeySet = true;
            ++this.position;
            return ObjectIntHashMapWithHashingStrategy.this.toNonSentinel(this.currentKey);
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (ObjectIntHashMapWithHashingStrategy.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                ObjectIntHashMapWithHashingStrategy.this.removeKeyAtIndex(ObjectIntHashMapWithHashingStrategy.this.toNonSentinel(this.currentKey), index);
            } else {
                ObjectIntHashMapWithHashingStrategy.this.removeKey(this.currentKey);
            }
        }
    }

    private class KeySet
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public boolean equals(Object obj) {
            Set other;
            if (obj instanceof Set && (other = (Set)obj).size() == this.size()) {
                return this.containsAll(other);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            Object[] table = ObjectIntHashMapWithHashingStrategy.this.keys;
            for (int i = 0; i < table.length; ++i) {
                Object key = table[i];
                if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                Object nonSentinelKey = ObjectIntHashMapWithHashingStrategy.this.toNonSentinel(key);
                hashCode += nonSentinelKey == null ? 0 : ObjectIntHashMapWithHashingStrategy.this.hashingStrategy.computeHashCode(nonSentinelKey);
            }
            return hashCode;
        }

        @Override
        public int size() {
            return ObjectIntHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectIntHashMapWithHashingStrategy.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ObjectIntHashMapWithHashingStrategy.this.containsKey(o);
        }

        @Override
        public Object[] toArray() {
            int size = ObjectIntHashMapWithHashingStrategy.this.size();
            Object[] result = new Object[size];
            this.copyKeys(result);
            return result;
        }

        @Override
        public <T> T[] toArray(T[] result) {
            int size = ObjectIntHashMapWithHashingStrategy.this.size();
            if (result.length < size) {
                result = (Object[])Array.newInstance(result.getClass().getComponentType(), size);
            }
            this.copyKeys(result);
            if (size < result.length) {
                result[size] = null;
            }
            return result;
        }

        @Override
        public boolean add(K key) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(Object key) {
            int oldSize = ObjectIntHashMapWithHashingStrategy.this.size();
            ObjectIntHashMapWithHashingStrategy.this.removeKey(key);
            return oldSize != ObjectIntHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object aCollection : collection) {
                if (ObjectIntHashMapWithHashingStrategy.this.containsKey(aCollection)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int oldSize = ObjectIntHashMapWithHashingStrategy.this.size();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (collection.contains(next)) continue;
                iterator.remove();
            }
            return oldSize != ObjectIntHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            int oldSize = ObjectIntHashMapWithHashingStrategy.this.size();
            for (Object object : collection) {
                ObjectIntHashMapWithHashingStrategy.this.removeKey(object);
            }
            return oldSize != ObjectIntHashMapWithHashingStrategy.this.size();
        }

        @Override
        public void clear() {
            ObjectIntHashMapWithHashingStrategy.this.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        private void copyKeys(Object[] result) {
            int count = 0;
            for (int i = 0; i < ObjectIntHashMapWithHashingStrategy.this.keys.length; ++i) {
                Object key = ObjectIntHashMapWithHashingStrategy.this.keys[i];
                if (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                result[count++] = ObjectIntHashMapWithHashingStrategy.this.keys[i];
            }
        }
    }

    private class InternalIntIterator
    implements MutableIntIterator {
        private int count;
        private int position;

        private InternalIntIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count != ObjectIntHashMapWithHashingStrategy.this.size();
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] keys = ObjectIntHashMapWithHashingStrategy.this.keys;
            while (!ObjectIntHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            int result = ObjectIntHashMapWithHashingStrategy.this.values[this.position];
            ++this.count;
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            if (this.position == 0 || !ObjectIntHashMapWithHashingStrategy.isNonSentinel(ObjectIntHashMapWithHashingStrategy.this.keys[this.position - 1])) {
                throw new IllegalStateException();
            }
            ObjectIntHashMapWithHashingStrategy.this.remove(ObjectIntHashMapWithHashingStrategy.this.keys[this.position - 1]);
            --this.count;
        }
    }
}

