/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.DoubleIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyShortIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.ShortIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.DoubleFunction0;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ShortDoubleToDoubleFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ShortToDoubleFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.ShortDoublePredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.ShortDoubleProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.DoubleShortMaps;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.ShortDoubleMaps;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.MutableDoubleIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.MutableShortIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.ShortIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.ImmutableShortDoubleMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.MutableDoubleShortMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.MutableShortDoubleMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.primitive.ShortDoubleMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.DoubleSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableShortSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.ShortSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.primitive.ShortDoublePair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.SpreadFunctions;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive.AbstractLazyShortIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableDoubleValuesMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableShortKeySet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.ImmutableShortMapKeySet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.MutableShortKeysMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.SynchronizedShortDoubleMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableShortDoubleMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ShortDoubleHashMap
extends AbstractMutableDoubleValuesMap
implements MutableShortDoubleMap,
Externalizable,
MutableShortKeysMap {
    private static final double EMPTY_VALUE = 0.0;
    private static final long serialVersionUID = 1L;
    private static final short EMPTY_KEY = 0;
    private static final short REMOVED_KEY = 1;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 2;
    private static final int INITIAL_LINEAR_PROBE = 16;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private short[] keys;
    private double[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableDoubleValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public ShortDoubleHashMap() {
        this.allocateTable(16);
    }

    public ShortDoubleHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public ShortDoubleHashMap(ShortDoubleMap map) {
        if (map instanceof ShortDoubleHashMap && ((ShortDoubleHashMap)map).occupiedWithSentinels == 0) {
            ShortDoubleHashMap hashMap = (ShortDoubleHashMap)map;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keys = Arrays.copyOf(hashMap.keys, hashMap.keys.length);
            this.values = Arrays.copyOf(hashMap.values, hashMap.values.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map);
        }
    }

    public static ShortDoubleHashMap newWithKeysValues(short key1, double value1) {
        return new ShortDoubleHashMap(1).withKeyValue(key1, value1);
    }

    public static ShortDoubleHashMap newWithKeysValues(short key1, double value1, short key2, double value2) {
        return new ShortDoubleHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static ShortDoubleHashMap newWithKeysValues(short key1, double value1, short key2, double value2, short key3, double value3) {
        return new ShortDoubleHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static ShortDoubleHashMap newWithKeysValues(short key1, double value1, short key2, double value2, short key3, double value3, short key4, double value4) {
        return new ShortDoubleHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableDoubleValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected double getEmptyValue() {
        return 0.0;
    }

    @Override
    protected int getTableSize() {
        return this.values.length;
    }

    @Override
    protected double getValueAtIndex(int index) {
        return this.values[index];
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShortDoubleMap)) {
            return false;
        }
        ShortDoubleMap other = (ShortDoubleMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey((short)0) || other.containsKey((short)1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey((short)0) || Double.compare(this.sentinelValues.zeroValue, other.getOrThrow((short)0)) != 0)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey((short)1) || Double.compare(this.sentinelValues.oneValue, other.getOrThrow((short)1)) != 0)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            short key = this.keys[i];
            if (!ShortDoubleHashMap.isNonSentinel(key) || other.containsKey(key) && Double.compare(this.values[i], other.getOrThrow(key)) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ (int)(Double.doubleToLongBits(this.sentinelValues.zeroValue) ^ Double.doubleToLongBits(this.sentinelValues.zeroValue) >>> 32);
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ (int)(Double.doubleToLongBits(this.sentinelValues.oneValue) ^ Double.doubleToLongBits(this.sentinelValues.oneValue) >>> 32);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ (int)(Double.doubleToLongBits(this.values[i]) ^ Double.doubleToLongBits(this.values[i]) >>> 32);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            short key = this.keys[i];
            if (!ShortDoubleHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public MutableDoubleIterator doubleIterator() {
        return new InternalDoubleIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectDoubleToObjectFunction<? super V, ? extends V> function) {
        V result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keys, (short)0);
        Arrays.fill(this.values, 0.0);
    }

    @Override
    public void put(short key, double value) {
        if (ShortDoubleHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (ShortDoubleHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        short keyAtIndex = this.keys[index];
        if (keyAtIndex == key) {
            this.values[index] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(double value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(double value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    @Override
    public void putAll(ShortDoubleMap map) {
        map.forEachKeyValue(this::put);
    }

    @Override
    public void updateValues(ShortDoubleToDoubleFunction function) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            this.values[i] = function.valueOf(this.keys[i], this.values[i]);
        }
    }

    @Override
    public void removeKey(short key) {
        if (ShortDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (ShortDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.removeKeyAtIndex(index);
        }
    }

    @Override
    public void remove(short key) {
        this.removeKey(key);
    }

    @Override
    public double removeKeyIfAbsent(short key, double value) {
        if (ShortDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            double oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (ShortDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            double oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            double oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    @Override
    public double getIfAbsentPut(short key, double value) {
        if (ShortDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public double getAndPut(short key, double putValue, double defaultValue) {
        if (ShortDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
            } else if (this.sentinelValues.containsZeroKey) {
                double existingValue = this.sentinelValues.zeroValue;
                this.sentinelValues.zeroValue = putValue;
                return existingValue;
            }
            this.addEmptyKeyValue(putValue);
            return defaultValue;
        }
        if (ShortDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
            } else if (this.sentinelValues.containsOneKey) {
                double existingValue = this.sentinelValues.oneValue;
                this.sentinelValues.oneValue = putValue;
                return existingValue;
            }
            this.addRemovedKeyValue(putValue);
            return defaultValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            double existingValue = this.values[index];
            this.values[index] = putValue;
            return existingValue;
        }
        this.addKeyValueAtIndex(key, putValue, index);
        return defaultValue;
    }

    @Override
    public double getIfAbsentPut(short key, DoubleFunction0 function) {
        if (ShortDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.value();
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.value();
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        double value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> double getIfAbsentPutWith(short key, DoubleFunction<? super P> function, P parameter) {
        if (ShortDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.doubleValueOf(parameter);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value = function.doubleValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.doubleValueOf(parameter);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value = function.doubleValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        double value = function.doubleValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public double getIfAbsentPutWithKey(short key, ShortToDoubleFunction function) {
        if (ShortDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        double value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public double addToValue(short key, double toBeAdded) {
        if (ShortDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue += toBeAdded;
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue += toBeAdded;
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    private void addKeyValueAtIndex(short key, double value, int index) {
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = 1;
        this.values[index] = 0.0;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        short[] copy = new short[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    @Override
    public double updateValue(short key, double initialValueIfAbsent, DoubleToDoubleFunction function) {
        if (ShortDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        double value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public ShortDoubleHashMap withKeyValue(short key1, double value1) {
        this.put(key1, value1);
        return this;
    }

    public ShortDoubleHashMap withKeysValues(short key1, double value1, short key2, double value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ShortDoubleHashMap withKeysValues(short key1, double value1, short key2, double value2, short key3, double value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ShortDoubleHashMap withKeysValues(short key1, double value1, short key2, double value2, short key3, double value3, short key4, double value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    @Override
    public ShortDoubleHashMap withoutKey(short key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public ShortDoubleHashMap withoutAllKeys(ShortIterable keys) {
        keys.forEach(this::removeKey);
        return this;
    }

    @Override
    public MutableShortDoubleMap asUnmodifiable() {
        return new UnmodifiableShortDoubleMap(this);
    }

    @Override
    public MutableShortDoubleMap asSynchronized() {
        return new SynchronizedShortDoubleMap(this);
    }

    @Override
    public ImmutableShortDoubleMap toImmutable() {
        return ShortDoubleMaps.immutable.ofAll(this);
    }

    @Override
    public double get(short key) {
        return this.getIfAbsent(key, 0.0);
    }

    @Override
    public double getIfAbsent(short key, double ifAbsent) {
        if (ShortDoubleHashMap.isEmptyKey(key) || ShortDoubleHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        if (this.occupiedWithSentinels == 0) {
            return this.fastGetIfAbsent(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private double getForSentinel(short key, double ifAbsent) {
        if (ShortDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private double slowGetIfAbsent(short key, double ifAbsent) {
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    private double fastGetIfAbsent(short key, double ifAbsent) {
        int index = this.mask(key);
        for (int i = 0; i < 16; ++i) {
            short keyAtIndex = this.keys[index];
            if (keyAtIndex == key) {
                return this.values[index];
            }
            if (keyAtIndex == 0) {
                return ifAbsent;
            }
            index = index + 1 & this.keys.length - 1;
        }
        return this.slowGetIfAbsentTwo(key, ifAbsent);
    }

    private double slowGetIfAbsentTwo(short key, double ifAbsent) {
        int index = this.probeTwo(key, -1);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    @Override
    public double getOrThrow(short key) {
        if (ShortDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (ShortDoubleHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(short key) {
        if (ShortDoubleHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (ShortDoubleHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    @Override
    public void forEachKey(ShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((short)0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((short)1);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    @Override
    public void forEachKeyValue(ShortDoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    @Override
    public LazyShortIterable keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<ShortDoublePair> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public MutableDoubleShortMap flipUniqueValues() {
        MutableDoubleShortMap result = DoubleShortMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result;
    }

    @Override
    public ShortDoubleHashMap select(ShortDoublePredicate predicate) {
        ShortDoubleHashMap result = new ShortDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept((short)0, this.sentinelValues.zeroValue)) {
                result.put((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept((short)1, this.sentinelValues.oneValue)) {
                result.put((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public ShortDoubleHashMap reject(ShortDoublePredicate predicate) {
        ShortDoubleHashMap result = new ShortDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept((short)0, this.sentinelValues.zeroValue)) {
                result.put((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept((short)1, this.sentinelValues.oneValue)) {
                result.put((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeShort(0);
                out.writeDouble(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeShort(1);
                out.writeDouble(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeShort(this.keys[i]);
            out.writeDouble(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readShort(), in.readDouble());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        short[] old = this.keys;
        double[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ShortDoubleHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(short element) {
        int index = this.mask(element);
        short keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        for (int i = 1; i < 16; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(short element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 16; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            short keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(short element, int removedIndex) {
        int nextIndex = SpreadFunctions.shortSpreadOne(element);
        int spreadTwo = Integer.reverse(SpreadFunctions.shortSpreadTwo(element)) | 1;
        short keyAtIndex;
        while ((keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(short element) {
        int code = SpreadFunctions.shortSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(short element) {
        int code = SpreadFunctions.shortSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new short[sizeToAllocate];
        this.values = new double[sizeToAllocate];
    }

    private static boolean isEmptyKey(short key) {
        return key == 0;
    }

    private static boolean isRemovedKey(short key) {
        return key == 1;
    }

    private static boolean isNonSentinel(short key) {
        return !ShortDoubleHashMap.isEmptyKey(key) && !ShortDoubleHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !ShortDoubleHashMap.isEmptyKey(this.keys[index]) && !ShortDoubleHashMap.isRemovedKey(this.keys[index]);
    }

    private int maxOccupiedWithData() {
        return this.keys.length >> 1;
    }

    @Override
    public MutableShortSet keySet() {
        return new KeySet();
    }

    @Override
    public MutableDoubleCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ short[] access$302(ShortDoubleHashMap x0, short[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ double[] access$502(ShortDoubleHashMap x0, double[] x1) {
        x0.values = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<ShortDoublePair> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super ShortDoublePair> procedure) {
            if (ShortDoubleHashMap.this.sentinelValues != null) {
                if (((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair((short)0, ((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.zeroValue));
                }
                if (((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair((short)1, ((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < ShortDoubleHashMap.this.keys.length; ++i) {
                if (!ShortDoubleHashMap.isNonSentinel(ShortDoubleHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ShortDoubleHashMap.this.keys[i], ShortDoubleHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ShortDoublePair> objectIntProcedure) {
            int index = 0;
            if (ShortDoubleHashMap.this.sentinelValues != null) {
                if (((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair((short)0, ((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair((short)1, ((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < ShortDoubleHashMap.this.keys.length; ++i) {
                if (!ShortDoubleHashMap.isNonSentinel(ShortDoubleHashMap.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(ShortDoubleHashMap.this.keys[i], ShortDoubleHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ShortDoublePair, ? super P> procedure, P parameter) {
            if (ShortDoubleHashMap.this.sentinelValues != null) {
                if (((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair((short)0, ((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair((short)1, ((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < ShortDoubleHashMap.this.keys.length; ++i) {
                if (!ShortDoubleHashMap.isNonSentinel(ShortDoubleHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ShortDoubleHashMap.this.keys[i], ShortDoubleHashMap.this.values[i]), parameter);
            }
        }

        @Override
        public Iterator<ShortDoublePair> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<ShortDoublePair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public ShortDoublePair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (ShortDoubleHashMap.this.containsKey((short)0)) {
                        return PrimitiveTuples.pair((short)0, ((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (ShortDoubleHashMap.this.containsKey((short)1)) {
                        return PrimitiveTuples.pair((short)1, ((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.oneValue);
                    }
                }
                short[] keys = ShortDoubleHashMap.this.keys;
                while (!ShortDoubleHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ShortDoublePair result = PrimitiveTuples.pair(keys[this.position], ShortDoubleHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ShortDoubleHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableDoubleValuesMap.AbstractDoubleValuesCollection {
        private ValuesCollection() {
        }

        @Override
        public MutableDoubleIterator doubleIterator() {
            return ShortDoubleHashMap.this.doubleIterator();
        }

        @Override
        public boolean remove(double item) {
            int oldSize = ShortDoubleHashMap.this.size();
            if (ShortDoubleHashMap.this.sentinelValues != null && ((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.containsZeroKey && Double.compare(item, ((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.zeroValue) == 0) {
                ShortDoubleHashMap.this.removeKey((short)0);
            }
            if (ShortDoubleHashMap.this.sentinelValues != null && ((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.containsOneKey && Double.compare(item, ((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.oneValue) == 0) {
                ShortDoubleHashMap.this.removeKey((short)1);
            }
            for (int i = 0; i < ShortDoubleHashMap.this.keys.length; ++i) {
                if (!ShortDoubleHashMap.isNonSentinel(ShortDoubleHashMap.this.keys[i]) || Double.compare(item, ShortDoubleHashMap.this.values[i]) != 0) continue;
                ShortDoubleHashMap.this.removeKey(ShortDoubleHashMap.this.keys[i]);
            }
            return oldSize != ShortDoubleHashMap.this.size();
        }

        @Override
        public boolean retainAll(DoubleIterable source) {
            int oldSize = ShortDoubleHashMap.this.size();
            DoubleSet sourceSet = source instanceof DoubleSet ? (DoubleSet)source : source.toSet();
            ShortDoubleHashMap retained = ShortDoubleHashMap.this.select((short key, double value) -> sourceSet.contains(value));
            if (retained.size() != oldSize) {
                ShortDoubleHashMap.access$302(ShortDoubleHashMap.this, retained.keys);
                ShortDoubleHashMap.access$502(ShortDoubleHashMap.this, retained.values);
                ShortDoubleHashMap.this.sentinelValues = retained.sentinelValues;
                ShortDoubleHashMap.this.occupiedWithData = retained.occupiedWithData;
                ShortDoubleHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public MutableDoubleCollection newEmpty() {
            return new DoubleHashBag();
        }
    }

    private class KeySet
    extends AbstractMutableShortKeySet {
        private KeySet() {
        }

        @Override
        protected MutableShortKeysMap getOuter() {
            return ShortDoubleHashMap.this;
        }

        @Override
        protected AbstractMutableDoubleValuesMap.SentinelValues getSentinelValues() {
            return ShortDoubleHashMap.this.sentinelValues;
        }

        @Override
        protected short getKeyAtIndex(int index) {
            return ShortDoubleHashMap.this.keys[index];
        }

        @Override
        protected int getTableSize() {
            return ShortDoubleHashMap.this.keys.length;
        }

        @Override
        public MutableShortIterator shortIterator() {
            return new KeySetIterator();
        }

        @Override
        public boolean retainAll(ShortIterable source) {
            int oldSize = ShortDoubleHashMap.this.size();
            ShortSet sourceSet = source instanceof ShortSet ? (ShortSet)source : source.toSet();
            ShortDoubleHashMap retained = ShortDoubleHashMap.this.select((short key, double value) -> sourceSet.contains(key));
            if (retained.size() != oldSize) {
                ShortDoubleHashMap.access$302(ShortDoubleHashMap.this, retained.keys);
                ShortDoubleHashMap.access$502(ShortDoubleHashMap.this, retained.values);
                ShortDoubleHashMap.this.sentinelValues = retained.sentinelValues;
                ShortDoubleHashMap.this.occupiedWithData = retained.occupiedWithData;
                ShortDoubleHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(short ... source) {
            return this.retainAll(ShortHashSet.newSetWith(source));
        }

        @Override
        public ShortSet freeze() {
            ShortDoubleHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (ShortDoubleHashMap.this.sentinelValues != null) {
                containsZeroKey = ((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((ShortDoubleHashMap)ShortDoubleHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableShortMapKeySet(ShortDoubleHashMap.this.keys, ShortDoubleHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }

        @Override
        public MutableShortSet newEmpty() {
            return new ShortHashSet();
        }
    }

    private class KeySetIterator
    implements MutableShortIterator {
        private int count;
        private int position;
        private short lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ShortDoubleHashMap.this.size();
        }

        @Override
        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ShortDoubleHashMap.this.containsKey((short)0)) {
                    this.lastKey = 0;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ShortDoubleHashMap.this.containsKey((short)1)) {
                    this.lastKey = 1;
                    return this.lastKey;
                }
            }
            short[] keys = ShortDoubleHashMap.this.keys;
            while (!ShortDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            ShortDoubleHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyShortIterable {
        private KeysView() {
        }

        @Override
        public ShortIterator shortIterator() {
            return new UnmodifiableShortIterator(new KeySetIterator());
        }

        @Override
        public void each(ShortProcedure procedure) {
            ShortDoubleHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalDoubleIterator
    implements MutableDoubleIterator {
        private int count;
        private int position;
        private short lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalDoubleIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ShortDoubleHashMap.this.size();
        }

        @Override
        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ShortDoubleHashMap.this.containsKey((short)0)) {
                    this.lastKey = 0;
                    return ShortDoubleHashMap.this.get((short)0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ShortDoubleHashMap.this.containsKey((short)1)) {
                    this.lastKey = 1;
                    return ShortDoubleHashMap.this.get((short)1);
                }
            }
            short[] keys = ShortDoubleHashMap.this.keys;
            while (!ShortDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            double result = ShortDoubleHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            ShortDoubleHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

