/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.multimap.list;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Maps;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.MutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.MutableMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.multimap.Multimap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.Pair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.mutable.FastList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.UnifiedMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.multimap.list.AbstractMutableListMultimap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;
import java.io.Externalizable;
import java.util.Collection;

public final class FastListMultimap<K, V>
extends AbstractMutableListMultimap<K, V>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_CAPACITY = 1;
    private int initialListCapacity;

    public FastListMultimap() {
        this.initialListCapacity = 1;
    }

    public FastListMultimap(int distinctKeys, int valuesPerKey) {
        super(Math.max(distinctKeys * 2, 16));
        if (distinctKeys < 0 || valuesPerKey < 0) {
            throw new IllegalArgumentException("Both arguments must be positive.");
        }
        this.initialListCapacity = valuesPerKey;
    }

    public FastListMultimap(Multimap<? extends K, ? extends V> multimap) {
        this(multimap.keysView().size(), multimap instanceof FastListMultimap ? ((FastListMultimap)multimap).initialListCapacity : 1);
        this.putAll(multimap);
    }

    public FastListMultimap(Pair<K, V> ... pairs) {
        super(pairs);
    }

    public FastListMultimap(Iterable<Pair<K, V>> inputIterable) {
        super(inputIterable);
    }

    public static <K, V> FastListMultimap<K, V> newMultimap() {
        return new FastListMultimap<K, V>();
    }

    public static <K, V> FastListMultimap<K, V> newMultimap(Multimap<? extends K, ? extends V> multimap) {
        return new FastListMultimap<K, V>(multimap);
    }

    public static <K, V> FastListMultimap<K, V> newMultimap(Pair<K, V> ... pairs) {
        return new FastListMultimap<K, V>(pairs);
    }

    public static <K, V> FastListMultimap<K, V> newMultimap(Iterable<Pair<K, V>> inputIterable) {
        return new FastListMultimap<K, V>(inputIterable);
    }

    @Override
    protected MutableMap<K, MutableList<V>> createMap() {
        return Maps.mutable.empty();
    }

    @Override
    protected MutableMap<K, MutableList<V>> createMapWithKeyCount(int keyCount) {
        return UnifiedMap.newMap(keyCount);
    }

    @Override
    protected MutableList<V> createCollection() {
        return Lists.mutable.withInitialCapacity(this.initialListCapacity);
    }

    public void trimToSize() {
        for (Collection collection : this.map.values()) {
            FastList fastList = (FastList)collection;
            fastList.trimToSize();
        }
    }

    @Override
    public FastListMultimap<K, V> newEmpty() {
        return new FastListMultimap<K, V>();
    }

    @Override
    public MutableBagMultimap<V, K> flip() {
        return Iterate.flip(this);
    }

    @Override
    public FastListMultimap<K, V> selectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return (FastListMultimap)this.selectKeysValues(predicate, this.newEmpty());
    }

    @Override
    public FastListMultimap<K, V> rejectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return (FastListMultimap)this.rejectKeysValues(predicate, this.newEmpty());
    }

    @Override
    public FastListMultimap<K, V> selectKeysMultiValues(Predicate2<? super K, ? super RichIterable<V>> predicate) {
        return (FastListMultimap)this.selectKeysMultiValues(predicate, this.newEmpty());
    }

    @Override
    public FastListMultimap<K, V> rejectKeysMultiValues(Predicate2<? super K, ? super RichIterable<V>> predicate) {
        return (FastListMultimap)this.rejectKeysMultiValues(predicate, this.newEmpty());
    }
}

