/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.parallel;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.Bag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Sets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.ListIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.MapIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.SetIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.sorted.SortedSetIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.mutable.HashBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.mutable.CompositeFastList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.parallel.AbstractProcedureCombiner;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.sorted.mutable.TreeSortedSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.internal.DefaultSpeciesNewStrategy;
import java.util.Collection;

public abstract class AbstractPredicateBasedCombiner<T, BT extends Procedure<T>>
extends AbstractProcedureCombiner<BT> {
    private static final long serialVersionUID = 1L;
    protected final Collection<T> result;

    protected AbstractPredicateBasedCombiner(boolean useCombineOne, Iterable<?> sourceCollection, int initialCapacity, Collection<T> targetCollection) {
        super(useCombineOne);
        this.result = this.initializeResult(sourceCollection, targetCollection, initialCapacity);
    }

    protected final Collection<T> initializeResult(Iterable<?> sourceCollection, Collection<T> targetCollection, int initialCapacity) {
        if (targetCollection != null) {
            return targetCollection;
        }
        if (sourceCollection instanceof ListIterable) {
            return new CompositeFastList();
        }
        if (sourceCollection instanceof SortedSetIterable) {
            return TreeSortedSet.newSet(((SortedSetIterable)sourceCollection).comparator());
        }
        if (sourceCollection instanceof SetIterable) {
            this.setCombineOne(true);
            return Sets.mutable.withInitialCapacity(initialCapacity);
        }
        if (sourceCollection instanceof Bag || sourceCollection instanceof MapIterable) {
            return HashBag.newBag();
        }
        return this.createResultForCollection(sourceCollection, initialCapacity);
    }

    private Collection<T> createResultForCollection(Iterable<?> sourceCollection, int initialCapacity) {
        if (sourceCollection instanceof Collection) {
            return DefaultSpeciesNewStrategy.INSTANCE.speciesNew((Collection)sourceCollection, initialCapacity);
        }
        return Lists.mutable.withInitialCapacity(initialCapacity);
    }

    public Collection<T> getResult() {
        return this.result;
    }
}

