/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.fixed;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.set.FixedSizeSetFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.FixedSizeSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.MutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collector.Collectors2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.fixed.DoubletonSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.fixed.EmptySet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.fixed.QuadrupletonSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.fixed.SingletonSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.fixed.TripletonSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.UnifiedSet;
import java.util.Objects;
import java.util.stream.Stream;

public class FixedSizeSetFactoryImpl
implements FixedSizeSetFactory {
    public static final FixedSizeSetFactory INSTANCE = new FixedSizeSetFactoryImpl();
    private static final FixedSizeSet<?> EMPTY_SET = new EmptySet();

    @Override
    public <T> FixedSizeSet<T> empty() {
        return EMPTY_SET;
    }

    @Override
    public <T> FixedSizeSet<T> of() {
        return this.empty();
    }

    @Override
    public <T> FixedSizeSet<T> with() {
        return this.empty();
    }

    @Override
    public <T> FixedSizeSet<T> of(T one) {
        return this.with(one);
    }

    @Override
    public <T> FixedSizeSet<T> with(T one) {
        return new SingletonSet<T>(one);
    }

    @Override
    public <T> FixedSizeSet<T> of(T one, T two) {
        return this.with(one, two);
    }

    @Override
    public <T> FixedSizeSet<T> with(T one, T two) {
        if (Objects.equals(one, two)) {
            return this.of(one);
        }
        return new DoubletonSet<T>(one, two);
    }

    @Override
    public <T> FixedSizeSet<T> of(T one, T two, T three) {
        return this.with(one, two, three);
    }

    @Override
    public <T> FixedSizeSet<T> with(T one, T two, T three) {
        if (Objects.equals(one, two)) {
            return this.of(one, three);
        }
        if (Objects.equals(one, three)) {
            return this.of(one, two);
        }
        if (Objects.equals(two, three)) {
            return this.of(one, two);
        }
        return new TripletonSet<T>(one, two, three);
    }

    @Override
    public <T> FixedSizeSet<T> of(T one, T two, T three, T four) {
        return this.with(one, two, three, four);
    }

    @Override
    public <T> FixedSizeSet<T> with(T one, T two, T three, T four) {
        if (Objects.equals(one, two)) {
            return this.of(one, three, four);
        }
        if (Objects.equals(one, three)) {
            return this.of(one, two, four);
        }
        if (Objects.equals(one, four)) {
            return this.of(one, two, three);
        }
        if (Objects.equals(two, three)) {
            return this.of(one, two, four);
        }
        if (Objects.equals(two, four)) {
            return this.of(one, two, three);
        }
        if (Objects.equals(three, four)) {
            return this.of(one, two, three);
        }
        return new QuadrupletonSet<T>(one, two, three, four);
    }

    @Override
    public <T> MutableSet<T> ofAll(Iterable<? extends T> items) {
        return this.withAll(items);
    }

    @Override
    public <T> MutableSet<T> withAll(Iterable<? extends T> items) {
        UnifiedSet<T> set = UnifiedSet.newSet(items);
        switch (set.size()) {
            case 0: {
                return new EmptySet();
            }
            case 1: {
                Object[] itemArray = set.toArray();
                return new SingletonSet<Object>(itemArray[0]);
            }
            case 2: {
                Object[] itemArray = set.toArray();
                return new DoubletonSet<Object>(itemArray[0], itemArray[1]);
            }
            case 3: {
                Object[] itemArray = set.toArray();
                return new TripletonSet<Object>(itemArray[0], itemArray[1], itemArray[2]);
            }
            case 4: {
                Object[] itemArray = set.toArray();
                return new QuadrupletonSet<Object>(itemArray[0], itemArray[1], itemArray[2], itemArray[3]);
            }
        }
        return set;
    }

    @Override
    public <T> MutableSet<T> fromStream(Stream<? extends T> stream) {
        MutableSet set = stream.collect(Collectors2.toSet());
        switch (set.size()) {
            case 0: {
                return new EmptySet();
            }
            case 1: {
                Object[] itemArray = set.toArray();
                return new SingletonSet<Object>(itemArray[0]);
            }
            case 2: {
                Object[] itemArray = set.toArray();
                return new DoubletonSet<Object>(itemArray[0], itemArray[1]);
            }
            case 3: {
                Object[] itemArray = set.toArray();
                return new TripletonSet<Object>(itemArray[0], itemArray[1], itemArray[2]);
            }
            case 4: {
                Object[] itemArray = set.toArray();
                return new QuadrupletonSet<Object>(itemArray[0], itemArray[1], itemArray[2], itemArray[3]);
            }
        }
        return set;
    }
}

