/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.immutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.ByteIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.ByteSets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.ByteIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.MutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.ByteSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.ImmutableByteSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableByteSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.primitive.AbstractByteSet;

public abstract class AbstractImmutableByteSet
extends AbstractByteSet
implements ImmutableByteSet {
    @Override
    public ImmutableByteSet newWith(byte element) {
        return ByteHashSet.newSet(this).with(element).toImmutable();
    }

    @Override
    public ImmutableByteSet newWithout(byte element) {
        return ByteHashSet.newSet(this).without(element).toImmutable();
    }

    @Override
    public ImmutableByteSet newWithAll(ByteIterable elements) {
        return ByteHashSet.newSet(this).withAll(elements).toImmutable();
    }

    @Override
    public ImmutableByteSet newWithoutAll(ByteIterable elements) {
        return ByteHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    @Override
    public ByteSet freeze() {
        return this;
    }

    @Override
    public ImmutableByteSet toImmutable() {
        return this;
    }

    @Override
    public RichIterable<ByteIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add(this);
            } else {
                ByteIterator iterator = this.byteIterator();
                while (iterator.hasNext()) {
                    MutableByteSet batch = ByteSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add(batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }
}

