/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.immutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LongIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.LongSets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.LongIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.MutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.LongSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableLongSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.primitive.AbstractLongSet;

public abstract class AbstractImmutableLongSet
extends AbstractLongSet
implements ImmutableLongSet {
    @Override
    public ImmutableLongSet newWith(long element) {
        return LongHashSet.newSet(this).with(element).toImmutable();
    }

    @Override
    public ImmutableLongSet newWithout(long element) {
        return LongHashSet.newSet(this).without(element).toImmutable();
    }

    @Override
    public ImmutableLongSet newWithAll(LongIterable elements) {
        return LongHashSet.newSet(this).withAll(elements).toImmutable();
    }

    @Override
    public ImmutableLongSet newWithoutAll(LongIterable elements) {
        return LongHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    @Override
    public LongSet freeze() {
        return this;
    }

    @Override
    public ImmutableLongSet toImmutable() {
        return this;
    }

    @Override
    public RichIterable<LongIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add(this);
            } else {
                LongIterator iterator = this.longIterator();
                while (iterator.hasNext()) {
                    MutableLongSet batch = LongSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add(batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }
}

