/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.immutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.BooleanSets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.BooleanSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedBooleanProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class ImmutableBooleanSetSerializationProxy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private BooleanSet set;

    public ImmutableBooleanSetSerializationProxy() {
    }

    public ImmutableBooleanSetSerializationProxy(BooleanSet set) {
        this.set = set;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.set.size());
        try {
            this.set.forEach(new CheckedBooleanProcedure(){

                @Override
                public void safeValue(boolean item) throws Exception {
                    out.writeBoolean(item);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        MutableBooleanSet deserializedSet = BooleanSets.mutable.empty();
        for (int i = 0; i < size; ++i) {
            deserializedSet.add(in.readBoolean());
        }
        this.set = deserializedSet;
    }

    private Object readResolve() {
        return this.set.toImmutable();
    }
}

