/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.immutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.BooleanIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyBooleanIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Sets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.BooleanBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.BooleanLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.BooleanIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.MutableBooleanList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.ImmutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.BooleanSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.ImmutableBooleanSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.primitive.BooleanBooleanPair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.BooleanSets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.immutable.primitive.ImmutableBooleanEmptySet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.immutable.primitive.ImmutableBooleanSetSerializationProxy;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.immutable.primitive.ImmutableTrueFalseSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

final class ImmutableFalseSet
implements ImmutableBooleanSet,
Serializable {
    static final ImmutableBooleanSet INSTANCE = new ImmutableFalseSet();

    private ImmutableFalseSet() {
    }

    @Override
    public ImmutableBooleanSet newWith(boolean element) {
        return element ? ImmutableTrueFalseSet.INSTANCE : this;
    }

    @Override
    public ImmutableBooleanSet newWithout(boolean element) {
        return element ? this : ImmutableBooleanEmptySet.INSTANCE;
    }

    @Override
    public ImmutableBooleanSet newWithAll(BooleanIterable elements) {
        ImmutableBooleanSet result = this;
        BooleanIterator booleanIterator = elements.booleanIterator();
        while (booleanIterator.hasNext()) {
            result = result.newWith(booleanIterator.next());
        }
        return result;
    }

    @Override
    public ImmutableBooleanSet newWithoutAll(BooleanIterable elements) {
        return elements.contains(false) ? ImmutableBooleanEmptySet.INSTANCE : this;
    }

    @Override
    public BooleanIterator booleanIterator() {
        return new FalseIterator();
    }

    @Override
    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(BooleanProcedure procedure) {
        procedure.value(false);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, false);
    }

    @Override
    public RichIterable<BooleanIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.immutable.with(this);
    }

    @Override
    public int count(BooleanPredicate predicate) {
        return predicate.accept(false) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        return predicate.accept(false);
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        return predicate.accept(false);
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !predicate.accept(false);
    }

    @Override
    public ImmutableBooleanSet select(BooleanPredicate predicate) {
        return predicate.accept(false) ? this : ImmutableBooleanEmptySet.INSTANCE;
    }

    @Override
    public ImmutableBooleanSet reject(BooleanPredicate predicate) {
        return predicate.accept(false) ? ImmutableBooleanEmptySet.INSTANCE : this;
    }

    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return !predicate.accept(false) && ifNone;
    }

    @Override
    public <V> ImmutableSet<V> collect(BooleanToObjectFunction<? extends V> function) {
        return Sets.immutable.with(function.valueOf(false));
    }

    @Override
    public boolean[] toArray() {
        return new boolean[]{false};
    }

    @Override
    public boolean[] toArray(boolean[] target) {
        if (target.length < 1) {
            target = new boolean[]{false};
        } else {
            target[0] = false;
        }
        return target;
    }

    @Override
    public boolean contains(boolean value) {
        return !value;
    }

    @Override
    public boolean containsAll(boolean ... source) {
        for (boolean item : source) {
            if (!item) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(BooleanIterable source) {
        BooleanIterator iterator = source.booleanIterator();
        while (iterator.hasNext()) {
            if (!iterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public BooleanSet freeze() {
        return this;
    }

    @Override
    public ImmutableBooleanSet toImmutable() {
        return this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public LazyIterable<BooleanBooleanPair> cartesianProduct(BooleanSet set) {
        return BooleanSets.cartesianProduct(this, set);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BooleanSet)) {
            return false;
        }
        BooleanSet other = (BooleanSet)obj;
        return other.contains(false) && !other.contains(true);
    }

    @Override
    public int hashCode() {
        return 1237;
    }

    @Override
    public String toString() {
        return "[false]";
    }

    @Override
    public String makeString() {
        return "false";
    }

    @Override
    public String makeString(String separator) {
        return "false";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + "false" + end;
    }

    @Override
    public void appendString(Appendable appendable) {
        try {
            appendable.append("false");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        try {
            appendable.append("false");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append("false");
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MutableBooleanList toList() {
        return BooleanLists.mutable.withAll(this);
    }

    @Override
    public MutableBooleanSet toSet() {
        return BooleanSets.mutable.withAll(this);
    }

    @Override
    public MutableBooleanBag toBag() {
        return BooleanBags.mutable.withAll(this);
    }

    @Override
    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter(this);
    }

    private Object writeReplace() {
        return new ImmutableBooleanSetSerializationProxy(this);
    }

    private static final class FalseIterator
    implements BooleanIterator {
        private int currentIndex;

        private FalseIterator() {
        }

        @Override
        public boolean next() {
            if (this.currentIndex == 0) {
                ++this.currentIndex;
                return false;
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex == 0;
        }
    }
}

