/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.immutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.BooleanIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyBooleanIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Sets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.BooleanBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.BooleanLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.BooleanIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.MutableBooleanList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.ImmutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.BooleanSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.ImmutableBooleanSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.primitive.BooleanBooleanPair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.BooleanSets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.immutable.primitive.ImmutableBooleanEmptySet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.immutable.primitive.ImmutableBooleanSetSerializationProxy;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.immutable.primitive.ImmutableFalseSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.immutable.primitive.ImmutableTrueSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

final class ImmutableTrueFalseSet
implements ImmutableBooleanSet,
Serializable {
    static final ImmutableBooleanSet INSTANCE = new ImmutableTrueFalseSet();

    private ImmutableTrueFalseSet() {
    }

    @Override
    public ImmutableBooleanSet newWith(boolean element) {
        return INSTANCE;
    }

    @Override
    public ImmutableBooleanSet newWithout(boolean element) {
        return element ? ImmutableFalseSet.INSTANCE : ImmutableTrueSet.INSTANCE;
    }

    @Override
    public ImmutableBooleanSet newWithAll(BooleanIterable elements) {
        ImmutableBooleanSet result = this;
        BooleanIterator booleanIterator = elements.booleanIterator();
        while (booleanIterator.hasNext()) {
            result = result.newWith(booleanIterator.next());
        }
        return result;
    }

    @Override
    public ImmutableBooleanSet newWithoutAll(BooleanIterable elements) {
        ImmutableBooleanSet result = this;
        BooleanIterator booleanIterator = elements.booleanIterator();
        while (booleanIterator.hasNext()) {
            result = result.newWithout(booleanIterator.next());
        }
        return result;
    }

    @Override
    public BooleanIterator booleanIterator() {
        return new FalseTrueIterator();
    }

    @Override
    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(BooleanProcedure procedure) {
        procedure.value(false);
        procedure.value(true);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(function.valueOf(injectedValue, false), true);
    }

    @Override
    public RichIterable<BooleanIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        if (size == 1) {
            return Lists.immutable.with(BooleanSets.immutable.with(false), BooleanSets.immutable.with(true));
        }
        return Lists.immutable.with(this);
    }

    @Override
    public int count(BooleanPredicate predicate) {
        int count = 0;
        if (predicate.accept(false)) {
            ++count;
        }
        if (predicate.accept(true)) {
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        return predicate.accept(false) || predicate.accept(true);
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        return predicate.accept(false) && predicate.accept(true);
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !predicate.accept(false) && !predicate.accept(true);
    }

    @Override
    public ImmutableBooleanSet select(BooleanPredicate predicate) {
        if (predicate.accept(true)) {
            return predicate.accept(false) ? this : ImmutableTrueSet.INSTANCE;
        }
        return predicate.accept(false) ? ImmutableFalseSet.INSTANCE : ImmutableBooleanEmptySet.INSTANCE;
    }

    @Override
    public ImmutableBooleanSet reject(BooleanPredicate predicate) {
        if (predicate.accept(true)) {
            return predicate.accept(false) ? ImmutableBooleanEmptySet.INSTANCE : ImmutableFalseSet.INSTANCE;
        }
        return predicate.accept(false) ? ImmutableTrueSet.INSTANCE : this;
    }

    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        if (predicate.accept(false)) {
            return false;
        }
        if (predicate.accept(true)) {
            return true;
        }
        return ifNone;
    }

    @Override
    public <V> ImmutableSet<V> collect(BooleanToObjectFunction<? extends V> function) {
        return Sets.immutable.with(function.valueOf(false), function.valueOf(true));
    }

    @Override
    public boolean[] toArray() {
        return new boolean[]{false, true};
    }

    @Override
    public boolean[] toArray(boolean[] target) {
        if (target.length < 2) {
            target = new boolean[]{false, true};
        } else {
            target[0] = false;
            target[1] = true;
        }
        return target;
    }

    @Override
    public boolean contains(boolean value) {
        return true;
    }

    @Override
    public boolean containsAll(boolean ... source) {
        return true;
    }

    @Override
    public boolean containsAll(BooleanIterable source) {
        return true;
    }

    @Override
    public BooleanSet freeze() {
        return this;
    }

    @Override
    public ImmutableBooleanSet toImmutable() {
        return this;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public LazyIterable<BooleanBooleanPair> cartesianProduct(BooleanSet set) {
        return BooleanSets.cartesianProduct(this, set);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BooleanSet)) {
            return false;
        }
        BooleanSet other = (BooleanSet)obj;
        return other.contains(false) && other.contains(true);
    }

    @Override
    public int hashCode() {
        return 2468;
    }

    @Override
    public String toString() {
        return "[false, true]";
    }

    @Override
    public String makeString() {
        return "false, true";
    }

    @Override
    public String makeString(String separator) {
        return "false" + separator + "true";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + "false" + separator + "true" + end;
    }

    @Override
    public void appendString(Appendable appendable) {
        try {
            appendable.append("false, true");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        try {
            appendable.append("false");
            appendable.append(separator);
            appendable.append("true");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append("false");
            appendable.append(separator);
            appendable.append("true");
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MutableBooleanList toList() {
        return BooleanLists.mutable.withAll(this);
    }

    @Override
    public MutableBooleanSet toSet() {
        return BooleanSets.mutable.withAll(this);
    }

    @Override
    public MutableBooleanBag toBag() {
        return BooleanBags.mutable.withAll(this);
    }

    @Override
    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter(this);
    }

    private Object writeReplace() {
        return new ImmutableBooleanSetSerializationProxy(this);
    }

    private static final class FalseTrueIterator
    implements BooleanIterator {
        private int currentIndex;

        private FalseTrueIterator() {
        }

        @Override
        public boolean next() {
            switch (this.currentIndex) {
                case 0: {
                    ++this.currentIndex;
                    return false;
                }
                case 1: {
                    ++this.currentIndex;
                    return true;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < 2;
        }
    }
}

