/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.MutableCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Sets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.partition.set.PartitionMutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.ImmutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.MutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.SetIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.UnsortedSetIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.Pair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.PartitionPredicate2Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.PartitionProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.SelectInstancesOfProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collection.mutable.AbstractMutableCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.multimap.set.UnifiedSetMultimap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.partition.set.PartitionUnifiedSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.SynchronizedMutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.UnmodifiableMutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.internal.SetIterables;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.internal.SetIterate;
import java.util.Set;

public abstract class AbstractMutableSet<T>
extends AbstractMutableCollection<T>
implements MutableSet<T> {
    @Override
    public MutableSet<T> clone() {
        try {
            return (MutableSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public MutableSet<T> newEmpty() {
        return Sets.mutable.empty();
    }

    protected <K> MutableSet<K> newEmptySameSize() {
        return Sets.mutable.withInitialCapacity(this.size());
    }

    @Override
    public MutableSet<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    @Override
    public MutableSet<T> select(Predicate<? super T> predicate) {
        return (MutableSet)this.select(predicate, this.newEmpty());
    }

    @Override
    public <P> MutableSet<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.selectWith(predicate, parameter, this.newEmptySameSize());
    }

    @Override
    public MutableSet<T> reject(Predicate<? super T> predicate) {
        return this.reject(predicate, this.newEmptySameSize());
    }

    @Override
    public <P> MutableSet<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.rejectWith(predicate, parameter, this.newEmptySameSize());
    }

    @Override
    public PartitionMutableSet<T> partition(Predicate<? super T> predicate) {
        PartitionUnifiedSet partitionMutableSet = new PartitionUnifiedSet();
        this.forEach(new PartitionProcedure<T>(predicate, partitionMutableSet));
        return partitionMutableSet;
    }

    @Override
    public <P> PartitionMutableSet<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        PartitionUnifiedSet partitionMutableSet = new PartitionUnifiedSet();
        this.forEach(new PartitionPredicate2Procedure<T, P>(predicate, parameter, partitionMutableSet));
        return partitionMutableSet;
    }

    @Override
    public <S> MutableSet<S> selectInstancesOf(Class<S> clazz) {
        MutableCollection result = this.newEmpty();
        this.forEach(new SelectInstancesOfProcedure<S>(clazz, result));
        return result;
    }

    @Override
    public <V> MutableSet<V> collect(Function<? super T, ? extends V> function) {
        return this.collect(function, this.newEmptySameSize());
    }

    @Override
    public <V> MutableSet<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect(function, this.newEmptySameSize());
    }

    @Override
    public <P, V> MutableSet<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collectWith(function, parameter, this.newEmptySameSize());
    }

    @Override
    public <V> MutableSet<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.collectIf(predicate, function, this.newEmptySameSize());
    }

    @Override
    public <V> UnifiedSetMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.groupBy(function, UnifiedSetMultimap.newMultimap());
    }

    @Override
    public <V> UnifiedSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.groupByEach(function, UnifiedSetMultimap.newMultimap());
    }

    @Override
    public MutableSet<T> asUnmodifiable() {
        return UnmodifiableMutableSet.of(this);
    }

    @Override
    public MutableSet<T> asSynchronized() {
        return SynchronizedMutableSet.of(this);
    }

    @Override
    public ImmutableSet<T> toImmutable() {
        return Sets.immutable.withAll(this);
    }

    @Override
    @Deprecated
    public <S> MutableSet<Pair<T, S>> zip(Iterable<S> that) {
        return this.zip(that, this.newEmptySameSize());
    }

    @Override
    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        return this.zipWithIndex(this.newEmptySameSize());
    }

    @Override
    public boolean removeAllIterable(Iterable<?> iterable) {
        return SetIterate.removeAllIterable(this, iterable);
    }

    @Override
    public MutableSet<T> union(SetIterable<? extends T> set) {
        return SetIterables.union(this, set);
    }

    @Override
    public <R extends Set<T>> R unionInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.unionInto(this, set, targetSet);
    }

    @Override
    public MutableSet<T> intersect(SetIterable<? extends T> set) {
        return SetIterables.intersect(this, set);
    }

    @Override
    public <R extends Set<T>> R intersectInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.intersectInto(this, set, targetSet);
    }

    @Override
    public MutableSet<T> difference(SetIterable<? extends T> subtrahendSet) {
        return SetIterables.difference(this, subtrahendSet);
    }

    @Override
    public <R extends Set<T>> R differenceInto(SetIterable<? extends T> subtrahendSet, R targetSet) {
        return SetIterables.differenceInto(this, subtrahendSet, targetSet);
    }

    @Override
    public MutableSet<T> symmetricDifference(SetIterable<? extends T> setB) {
        return SetIterables.symmetricDifference(this, setB);
    }

    @Override
    public <R extends Set<T>> R symmetricDifferenceInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.symmetricDifferenceInto(this, set, targetSet);
    }

    @Override
    public boolean isSubsetOf(SetIterable<? extends T> candidateSuperset) {
        return SetIterables.isSubsetOf(this, candidateSuperset);
    }

    @Override
    public boolean isProperSubsetOf(SetIterable<? extends T> candidateSuperset) {
        return SetIterables.isProperSubsetOf(this, candidateSuperset);
    }

    @Override
    public MutableSet<UnsortedSetIterable<T>> powerSet() {
        return SetIterables.powerSet(this);
    }

    @Override
    public <B> LazyIterable<Pair<T, B>> cartesianProduct(SetIterable<B> set) {
        return SetIterables.cartesianProduct(this, set);
    }
}

