/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.set.MultiReaderSetFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.MultiReaderSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.MultiReaderUnifiedSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MultiReaderMutableSetFactory
implements MultiReaderSetFactory {
    public static final MultiReaderSetFactory INSTANCE = new MultiReaderMutableSetFactory();

    @Override
    public <T> MultiReaderSet<T> empty() {
        return MultiReaderUnifiedSet.newSet();
    }

    @Override
    public <T> MultiReaderSet<T> with(T ... items) {
        return MultiReaderUnifiedSet.newSetWith(items);
    }

    @Override
    public <T> MultiReaderSet<T> withInitialCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        return MultiReaderUnifiedSet.newSet(capacity);
    }

    @Override
    public <T> MultiReaderSet<T> withAll(Iterable<? extends T> iterable) {
        return MultiReaderUnifiedSet.newSet(iterable);
    }

    @Override
    public <T> MultiReaderSet<T> fromStream(Stream<? extends T> stream) {
        return stream.collect(Collectors.toCollection(MultiReaderUnifiedSet::newSet));
    }
}

