/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.IntIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.set.primitive.MutableIntSetFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableIntSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.IntSets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;
import java.util.stream.IntStream;

public class MutableIntSetFactoryImpl
implements MutableIntSetFactory {
    public static final MutableIntSetFactory INSTANCE = new MutableIntSetFactoryImpl();

    @Override
    public MutableIntSet empty() {
        return new IntHashSet();
    }

    @Override
    public MutableIntSet of() {
        return this.empty();
    }

    @Override
    public MutableIntSet with() {
        return this.empty();
    }

    @Override
    public MutableIntSet withInitialCapacity(int capacity) {
        return new IntHashSet(capacity);
    }

    @Override
    public MutableIntSet of(int ... items) {
        return this.with(items);
    }

    @Override
    public MutableIntSet with(int ... items) {
        if (items == null || items.length == 0) {
            return this.empty();
        }
        return IntHashSet.newSetWith(items);
    }

    @Override
    public MutableIntSet ofAll(IntIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableIntSet withAll(IntIterable items) {
        return IntHashSet.newSet(items);
    }

    @Override
    public MutableIntSet ofAll(Iterable<Integer> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableIntSet withAll(Iterable<Integer> iterable) {
        return Iterate.collectInt(iterable, Integer::intValue, IntSets.mutable.empty());
    }

    @Override
    public MutableIntSet ofAll(IntStream items) {
        return this.withAll(items);
    }

    @Override
    public MutableIntSet withAll(IntStream items) {
        return this.with(items.toArray());
    }
}

