/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.sorted.immutable;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.set.sorted.ImmutableSortedSetFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.sorted.ImmutableSortedSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.sorted.immutable.ImmutableEmptySortedSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.sorted.immutable.ImmutableTreeSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;
import java.util.Comparator;
import java.util.SortedSet;

public class ImmutableSortedSetFactoryImpl
implements ImmutableSortedSetFactory {
    public static final ImmutableSortedSetFactory INSTANCE = new ImmutableSortedSetFactoryImpl();

    @Override
    public <T> ImmutableSortedSet<T> empty() {
        return ImmutableEmptySortedSet.INSTANCE;
    }

    @Override
    public <T> ImmutableSortedSet<T> empty(Comparator<? super T> comparator) {
        return new ImmutableEmptySortedSet<T>(comparator);
    }

    @Override
    public <T> ImmutableSortedSet<T> of() {
        return this.empty();
    }

    @Override
    public <T> ImmutableSortedSet<T> with() {
        return this.empty();
    }

    @Override
    public <T> ImmutableSortedSet<T> of(T ... items) {
        return this.with(items);
    }

    @Override
    public <T> ImmutableSortedSet<T> with(T ... items) {
        if (items == null || items.length == 0) {
            return this.of();
        }
        return ImmutableTreeSet.newSetWith(items);
    }

    @Override
    public <T> ImmutableSortedSet<T> ofAll(Iterable<? extends T> items) {
        return this.withAll(items);
    }

    @Override
    public <T> ImmutableSortedSet<T> withAll(Iterable<? extends T> items) {
        if (items instanceof ImmutableSortedSet) {
            return (ImmutableSortedSet)items;
        }
        if (Iterate.isEmpty(items)) {
            return this.empty();
        }
        return ImmutableTreeSet.newSetFromIterable(items);
    }

    @Override
    public <T> ImmutableSortedSet<T> of(Comparator<? super T> comparator) {
        return this.with(comparator);
    }

    @Override
    public <T> ImmutableSortedSet<T> with(Comparator<? super T> comparator) {
        if (comparator == null) {
            return this.of();
        }
        return new ImmutableEmptySortedSet<T>(comparator);
    }

    @Override
    public <T> ImmutableSortedSet<T> of(Comparator<? super T> comparator, T ... items) {
        return this.with(comparator, items);
    }

    @Override
    public <T> ImmutableSortedSet<T> with(Comparator<? super T> comparator, T ... items) {
        if (items == null || items.length == 0) {
            return this.of(comparator);
        }
        return ImmutableTreeSet.newSetWith(comparator, items);
    }

    @Override
    public <T> ImmutableSortedSet<T> ofAll(Comparator<? super T> comparator, Iterable<? extends T> items) {
        return this.withAll(comparator, items);
    }

    @Override
    public <T> ImmutableSortedSet<T> withAll(Comparator<? super T> comparator, Iterable<? extends T> iterable) {
        if (Iterate.isEmpty(iterable)) {
            return this.of(comparator);
        }
        return ImmutableTreeSet.newSetFromIterable(comparator, iterable);
    }

    @Override
    public <T> ImmutableSortedSet<T> ofSortedSet(SortedSet<T> set) {
        return this.withSortedSet(set);
    }

    @Override
    public <T> ImmutableSortedSet<T> withSortedSet(SortedSet<T> set) {
        if (set instanceof ImmutableSortedSet) {
            return (ImmutableSortedSet)((Object)set);
        }
        if (set.isEmpty()) {
            return this.of(set.comparator());
        }
        return ImmutableTreeSet.newSet(set);
    }
}

