/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.strategy.immutable;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.HashingStrategy;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.set.strategy.ImmutableHashingStrategySetFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.ImmutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.strategy.immutable.ImmutableEmptySetWithHashingStrategy;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.strategy.immutable.ImmutableUnifiedSetWithHashingStrategy;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;

public enum ImmutableHashingStrategySetFactoryImpl implements ImmutableHashingStrategySetFactory
{
    INSTANCE;


    @Override
    public <T> ImmutableSet<T> of(HashingStrategy<? super T> hashingStrategy) {
        return this.with(hashingStrategy);
    }

    @Override
    public <T> ImmutableSet<T> with(HashingStrategy<? super T> hashingStrategy) {
        return new ImmutableEmptySetWithHashingStrategy<T>(hashingStrategy);
    }

    @Override
    public <T> ImmutableSet<T> of(HashingStrategy<? super T> hashingStrategy, T ... items) {
        return this.with(hashingStrategy, items);
    }

    @Override
    public <T> ImmutableSet<T> with(HashingStrategy<? super T> hashingStrategy, T ... items) {
        if (items == null || items.length == 0) {
            return this.of(hashingStrategy);
        }
        return ImmutableUnifiedSetWithHashingStrategy.newSetWith(hashingStrategy, items);
    }

    @Override
    public <T> ImmutableSet<T> ofAll(HashingStrategy<? super T> hashingStrategy, Iterable<? extends T> items) {
        return this.withAll(hashingStrategy, items);
    }

    @Override
    public <T> ImmutableSet<T> withAll(HashingStrategy<? super T> hashingStrategy, Iterable<? extends T> items) {
        return this.with(hashingStrategy, Iterate.toArray(items));
    }

    @Override
    public <T> ImmutableSet<T> ofInitialCapacity(HashingStrategy<? super T> hashingStrategy, int capacity) {
        return this.withInitialCapacity(hashingStrategy, capacity);
    }

    @Override
    public <T> ImmutableSet<T> withInitialCapacity(HashingStrategy<? super T> hashingStrategy, int capacity) {
        return ImmutableUnifiedSetWithHashingStrategy.newSet(hashingStrategy, capacity);
    }
}

