/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.immutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.DoubleIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyDoubleIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ObjectDoubleIntToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.DoubleIntProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.DoubleIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.DoubleList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.MutableDoubleList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.ImmutableStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.DoubleStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.ImmutableDoubleStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.Stacks;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.DoubleStacks;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.iterator.SingletonDoubleIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import java.io.IOException;
import java.io.Serializable;

final class ImmutableDoubleSingletonStack
implements ImmutableDoubleStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final double element1;

    ImmutableDoubleSingletonStack(double element) {
        this.element1 = element;
    }

    @Override
    public DoubleIterator doubleIterator() {
        return new SingletonDoubleIterator(this.element1);
    }

    @Override
    public void each(DoubleProcedure procedure) {
        procedure.value(this.element1);
    }

    @Override
    public int count(DoublePredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        return !predicate.accept(this.element1);
    }

    @Override
    public double peek() {
        return this.element1;
    }

    @Override
    public DoubleList peek(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return new DoubleArrayList(0);
        }
        if (count == 1) {
            return DoubleArrayList.newListWith(this.element1);
        }
        throw new IllegalArgumentException("Count must be less than or equal to size: Count = " + count + " Size = 1");
    }

    @Override
    public double peekAt(int index) {
        this.checkNegativeCount(index);
        if (index == 0) {
            return this.element1;
        }
        throw new IllegalArgumentException("Index must be less than size: Index = " + index + " Size = 1");
    }

    @Override
    public ImmutableDoubleStack select(DoublePredicate predicate) {
        return predicate.accept(this.element1) ? DoubleStacks.immutable.with(this.element1) : DoubleStacks.immutable.with();
    }

    @Override
    public ImmutableDoubleStack reject(DoublePredicate predicate) {
        return predicate.accept(this.element1) ? DoubleStacks.immutable.with() : DoubleStacks.immutable.with(this.element1);
    }

    @Override
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    @Override
    public <V> ImmutableStack<V> collect(DoubleToObjectFunction<? extends V> function) {
        return Stacks.immutable.with(function.valueOf(this.element1));
    }

    @Override
    public double sum() {
        return this.element1;
    }

    @Override
    public double max() {
        return this.element1;
    }

    @Override
    public double maxIfEmpty(double defaultValue) {
        return this.element1;
    }

    @Override
    public double min() {
        return this.element1;
    }

    @Override
    public double minIfEmpty(double defaultValue) {
        return this.element1;
    }

    @Override
    public double average() {
        return this.element1;
    }

    @Override
    public double median() {
        return this.element1;
    }

    @Override
    public double[] toSortedArray() {
        return new double[]{this.element1};
    }

    @Override
    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newListWith(this.element1);
    }

    @Override
    public double[] toArray() {
        return new double[]{this.element1};
    }

    @Override
    public double[] toArray(double[] target) {
        if (target.length < 1) {
            target = new double[]{this.element1};
        } else {
            target[0] = this.element1;
        }
        return target;
    }

    @Override
    public boolean contains(double value) {
        return Double.compare(this.element1, value) == 0;
    }

    @Override
    public boolean containsAll(double ... source) {
        for (double value : source) {
            if (Double.compare(this.element1, value) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        DoubleIterator iterator = source.doubleIterator();
        while (iterator.hasNext()) {
            if (Double.compare(this.element1, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableDoubleList toList() {
        return DoubleArrayList.newListWith(this.element1);
    }

    @Override
    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSetWith(this.element1);
    }

    @Override
    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBagWith(this.element1);
    }

    @Override
    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter(this);
    }

    @Override
    public ImmutableDoubleStack toImmutable() {
        return this;
    }

    @Override
    public ImmutableDoubleStack push(double element) {
        return DoubleStacks.immutable.with(this.element1, element);
    }

    @Override
    public ImmutableDoubleStack pop() {
        return DoubleStacks.immutable.with();
    }

    @Override
    public ImmutableDoubleStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        if (count == 1) {
            return DoubleStacks.immutable.with();
        }
        throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = 1");
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.element1);
    }

    @Override
    public RichIterable<DoubleIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.immutable.with(this);
    }

    @Override
    public double getFirst() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getFirst() not implemented yet");
    }

    @Override
    public int indexOf(double value) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".indexOf() not implemented yet");
    }

    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectDoubleIntToObjectFunction<? super T, ? extends T> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".injectIntoWithIndex() not implemented yet");
    }

    @Override
    public void forEachWithIndex(DoubleIntProcedure procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof DoubleStack)) {
            return false;
        }
        DoubleStack stack = (DoubleStack)otherStack;
        if (stack.size() != 1) {
            return false;
        }
        return Double.compare(this.element1, stack.peek()) == 0;
    }

    @Override
    public int hashCode() {
        return 31 + (int)(Double.doubleToLongBits(this.element1) ^ Double.doubleToLongBits(this.element1) >>> 32);
    }

    @Override
    public String toString() {
        return "[" + this.element1 + ']';
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

